/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.handlers;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.util.Platform;
import appeng.util.item.FluidList;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.handlers.FluidicCellInventoryHandler;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventory;
import com.thiakil.appliedfluidics.item.IFluidicStorageCell;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import java.util.HashSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FluidicCellInventory
implements IFluidicCellInventory {
    private static final String ITEM_TYPE_TAG = "it";
    private static final String ITEM_COUNT_TAG = "ic";
    private static final String ITEM_SLOT = "#";
    private static final String ITEM_SLOT_COUNT = "@";
    private static final String ITEM_PRE_FORMATTED_COUNT = "PF";
    private static final String ITEM_PRE_FORMATTED_SLOT = "PF#";
    private static final String ITEM_PRE_FORMATTED_NAME = "PN";
    private static final String ITEM_PRE_FORMATTED_FUZZY = "FP";
    private static final HashSet<String> BLACK_LIST = new HashSet();
    private static String[] itemSlots;
    private static String[] itemSlotCount;
    private final NBTTagCompound tagCompound;
    private final ISaveProvider container;
    private int maxItemTypes = 63;
    private short storedItems = 0;
    private int storedItemCount = 0;
    private IItemList<IAEFluidStack> cellItems;
    private ItemStack i;
    private IFluidicStorageCell cellType;
    private static int STORED_DIVIDER;

    protected FluidicCellInventory(NBTTagCompound data, ISaveProvider container) {
        this.tagCompound = data;
        this.container = container;
    }

    private FluidicCellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        if (itemSlots == null) {
            itemSlots = new String[this.maxItemTypes];
            itemSlotCount = new String[this.maxItemTypes];
            for (int x = 0; x < this.maxItemTypes; ++x) {
                FluidicCellInventory.itemSlots[x] = ITEM_SLOT + x;
                FluidicCellInventory.itemSlotCount[x] = ITEM_SLOT_COUNT + x;
            }
        }
        if (o.func_190926_b()) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellType = null;
        this.i = o;
        Item type = this.i.func_77973_b();
        if (type instanceof IFluidicStorageCell) {
            this.cellType = (IFluidicStorageCell)this.i.func_77973_b();
            this.maxItemTypes = this.cellType.getTotalTypes(this.i);
        }
        if (this.cellType == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (!this.cellType.isStorageCell(this.i)) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (this.maxItemTypes > 63) {
            this.maxItemTypes = 63;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        this.container = container;
        this.tagCompound = Platform.openNbtData((ItemStack)o);
        this.storedItems = this.tagCompound.func_74765_d(ITEM_TYPE_TAG);
        this.storedItemCount = this.tagCompound.func_74762_e(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    public static IMEInventoryHandler<IAEFluidStack> getCell(ItemStack o, ISaveProvider container2) {
        try {
            return new FluidicCellInventoryHandler(new FluidicCellInventory(o, container2));
        }
        catch (AppEngException e) {
            return null;
        }
    }

    private static boolean isStorageCell(ItemStack i) {
        if (i.func_190926_b()) {
            return false;
        }
        try {
            Item type = i.func_77973_b();
            if (type instanceof IFluidicStorageCell) {
                return !((IFluidicStorageCell)type).storableInStorageCell();
            }
        }
        catch (Throwable err) {
            return true;
        }
        return false;
    }

    public static boolean isCell(ItemStack i) {
        if (i.func_190926_b()) {
            return false;
        }
        Item type = i.func_77973_b();
        if (type instanceof IFluidicStorageCell) {
            return ((IFluidicStorageCell)type).isStorageCell(i);
        }
        return false;
    }

    public static void addBasicBlackList(String fluidName) {
        BLACK_LIST.add(fluidName);
    }

    private static boolean isBlackListed(IAEFluidStack input) {
        return BLACK_LIST.contains(input.getFluid().getName());
    }

    private boolean isEmpty(IMEInventory<IAEFluidStack> meInventory) {
        return meInventory.getAvailableItems((IItemList)new FluidList()).isEmpty();
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        int remainingItemCount;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (FluidicCellInventory.isBlackListed(input) || this.cellType.isBlackListed(this.i, input)) {
            return input;
        }
        FluidStack sharedfluidStack = input.getFluidStack();
        IAEFluidStack l = (IAEFluidStack)this.getCellItems().findPrecise((IAEStack)input);
        if (l != null) {
            long remainingItemSlots = this.getRemainingItemCount();
            if (remainingItemSlots < 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemSlots) {
                IAEFluidStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemSlots);
                    this.updateItemCount(remainingItemSlots);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.updateItemCount(input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = (int)this.getRemainingItemCount() - this.getBytesPerType() * 8) > 0) {
            if (input.getStackSize() > (long)remainingItemCount) {
                FluidStack toReturn = sharedfluidStack.copy();
                toReturn.amount = sharedfluidStack.amount - remainingItemCount;
                if (mode == Actionable.MODULATE) {
                    FluidStack toWrite = sharedfluidStack.copy();
                    toWrite.amount = remainingItemCount;
                    this.cellItems.add((IAEStack)new NBTAwareAEFluidStack(toWrite));
                    this.updateItemCount(toWrite.amount);
                    this.saveChanges();
                }
                return new NBTAwareAEFluidStack(toReturn);
            }
            if (mode == Actionable.MODULATE) {
                this.updateItemCount(input.getStackSize());
                this.cellItems.add((IAEStack)input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEFluidStack Results = null;
        IAEFluidStack l = (IAEFluidStack)this.getCellItems().findPrecise((IAEStack)request);
        if (l != null) {
            Results = l.copy();
            if (l.getStackSize() <= size) {
                Results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    this.updateItemCount(-l.getStackSize());
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                Results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.updateItemCount(-size);
                    this.saveChanges();
                }
            }
        }
        return Results;
    }

    IItemList<IAEFluidStack> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = new FluidList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    private void updateItemCount(long delta) {
        this.storedItemCount = (int)((long)this.storedItemCount + delta);
        this.tagCompound.func_74768_a(ITEM_COUNT_TAG, this.storedItemCount);
    }

    void saveChanges() {
        int itemCount = 0;
        int x = 0;
        for (IAEFluidStack v : this.cellItems) {
            itemCount = (int)((long)itemCount + v.getStackSize());
            NBTBase c = this.tagCompound.func_74781_a(itemSlots[x]);
            if (c instanceof NBTTagCompound) {
                v.writeToNBT((NBTTagCompound)c);
            } else {
                NBTTagCompound g = new NBTTagCompound();
                v.writeToNBT(g);
                this.tagCompound.func_74782_a(itemSlots[x], (NBTBase)g);
            }
            this.tagCompound.func_74768_a(itemSlotCount[x], (int)v.getStackSize());
            ++x;
        }
        int oldStoredItems = this.storedItems;
        this.storedItems = (short)this.cellItems.size();
        if (this.cellItems.isEmpty()) {
            this.tagCompound.func_82580_o(ITEM_TYPE_TAG);
        } else {
            this.tagCompound.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        this.storedItemCount = itemCount;
        if (itemCount == 0) {
            this.tagCompound.func_82580_o(ITEM_COUNT_TAG);
        } else {
            this.tagCompound.func_74768_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < this.maxItemTypes) {
            this.tagCompound.func_82580_o(itemSlots[x]);
            this.tagCompound.func_82580_o(itemSlotCount[x]);
            ++x;
        }
        if (this.container != null) {
            this.container.saveChanges((IMEInventory)this);
        }
    }

    protected void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = new FluidList();
        }
        this.cellItems.resetStatus();
        int types = (int)this.getStoredItemTypes();
        for (int slot = 0; slot < types; ++slot) {
            NBTTagCompound compoundTag = this.tagCompound.func_74775_l(itemSlots[slot]);
            int stackSize = this.tagCompound.func_74762_e(itemSlotCount[slot]);
            this.loadCellItem(compoundTag, stackSize);
        }
    }

    private void loadCellItem(NBTTagCompound compoundTag, int stackSize) {
        FluidStack t;
        try {
            t = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compoundTag);
            if (t == null) {
                FluidicsMod.logger.warn("Removing fluid " + compoundTag + " from storage cell because the associated fluid type couldn't be found.");
                return;
            }
        }
        catch (Throwable ex) {
            if (AEConfig.instance().isRemoveCrashingItemsOnLoad()) {
                FluidicsMod.logger.warn("Removing item " + compoundTag + " from storage cell because loading the FluidStack crashed.", ex);
                return;
            }
            throw ex;
        }
        t.amount = stackSize;
        if (t.amount > 0) {
            try {
                this.cellItems.add((IAEStack)new NBTAwareAEFluidStack(t));
            }
            catch (Throwable ex) {
                if (AEConfig.instance().isRemoveCrashingItemsOnLoad()) {
                    FluidicsMod.logger.warn("Removing fluid " + t + " from storage cell because processing the loaded fluid crashed.", ex);
                    return;
                }
                throw ex;
            }
        }
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        for (IAEFluidStack i : this.getCellItems()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    @Override
    public ItemStack getItemStack() {
        return this.i;
    }

    @Override
    public double getIdleDrain() {
        return this.cellType.getIdleDrain(this.i);
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.i);
    }

    @Override
    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    @Override
    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.i);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.i);
    }

    @Override
    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    @Override
    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    @Override
    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)STORED_DIVIDER;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    @Override
    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    @Override
    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    @Override
    public long getStoredItemTypes() {
        return this.storedItems;
    }

    @Override
    public long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    @Override
    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)STORED_DIVIDER + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)STORED_DIVIDER);
        if (div == 0) {
            return 0;
        }
        return STORED_DIVIDER - div;
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    static {
        STORED_DIVIDER = 1000;
    }
}

