/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.handlers;

import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.util.item.FluidList;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.PrecisePriorityList;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventory;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventoryHandler;
import com.thiakil.appliedfluidics.util.FuzzyFluidPriorityList;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class FluidicCellInventoryHandler
extends MEInventoryHandler<IAEFluidStack>
implements IFluidicCellInventoryHandler {
    private final IMEInventory<IAEFluidStack> internal;
    private IPartitionList<IAEFluidStack> myPartitionList;
    private IncludeExclude myWhitelist;

    public FluidicCellInventoryHandler(IMEInventory c) {
        super(c, StorageChannel.FLUIDS);
        this.internal = c;
        IFluidicCellInventory ci = this.getCellInv();
        if (ci != null) {
            ItemStack is;
            int x;
            FluidList priorityList = new FluidList();
            IInventory upgrades = ci.getUpgradesInventory();
            IInventory config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            block4: for (x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                is = upgrades.func_70301_a(x);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block4;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block4;
                    }
                }
            }
            for (x = 0; x < config.func_70302_i_(); ++x) {
                is = config.func_70301_a(x);
                if (is.func_190926_b()) continue;
                priorityList.add((IAEStack)new NBTAwareAEFluidStack(is));
            }
            this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
            if (!priorityList.isEmpty()) {
                if (hasFuzzy) {
                    this.setPartitionList(new FuzzyFluidPriorityList((IItemList<IAEFluidStack>)priorityList, fzMode));
                } else {
                    this.setPartitionList((IPartitionList<IAEFluidStack>)new PrecisePriorityList((IItemList)priorityList));
                }
            }
        }
    }

    @Override
    public IFluidicCellInventory getCellInv() {
        IMEInventory<IAEFluidStack> o = this.getInternal();
        return (IFluidicCellInventory)(o instanceof IFluidicCellInventory ? o : null);
    }

    @Override
    public boolean isPreformatted() {
        return this.getPartitionList() != null && !this.getPartitionList().isEmpty();
    }

    @Override
    public boolean isFuzzy() {
        return this.getPartitionList() instanceof FuzzyFluidPriorityList || this.getPartitionList() instanceof FuzzyPriorityList;
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return this.getWhitelist();
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if (val == 1 && this.isPreformatted()) {
            val = 2;
        }
        return val;
    }

    public IMEInventory<IAEFluidStack> getInternal() {
        return this.internal;
    }

    IPartitionList<IAEFluidStack> getPartitionList() {
        return this.myPartitionList;
    }

    public void setPartitionList(IPartitionList<IAEFluidStack> myPartitionList) {
        super.setPartitionList(myPartitionList);
        this.myPartitionList = myPartitionList;
    }

    public IncludeExclude getWhitelist() {
        return this.myWhitelist;
    }

    public void setWhitelist(IncludeExclude myWhitelist) {
        super.setWhitelist(myWhitelist);
        this.myWhitelist = myWhitelist;
    }
}

