/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.helpers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.settings.TickRates;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.tile.inventory.InvOperation;
import appeng.util.InventoryAdaptor;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.item.ItemFluidDrop;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidDualityInterface
extends DualityInterface {
    protected static Item FORGE_BUCKET = ForgeModContainer.getInstance().universalBucket;
    protected static List<Item> BUCKETS = Arrays.asList(Items.field_151131_as, Items.field_151129_at, Items.field_151117_aB, FORGE_BUCKET);
    private final AENetworkProxy gridProxy;
    private final IInterfaceHost iHost;
    private final MEMonitorPassThrough<IAEItemStack> items;
    private HashMap<ICraftingPatternDetails, PatternProxy> proxyPatterns = new HashMap(9);
    private ArrayList<FluidStack> pendingFluids = new ArrayList();
    private ArrayList<ItemStack> returnContainers = new ArrayList();
    private static final Collection<Block> BAD_BLOCKS = new HashSet<Block>(100);
    private MachineSource mySrc;

    public FluidDualityInterface(AENetworkProxy networkProxy, IInterfaceHost ih) {
        super(networkProxy, ih);
        this.gridProxy = networkProxy;
        this.iHost = ih;
        this.mySrc = new MachineSource((IActionHost)this.iHost);
        Field itemField = null;
        try {
            itemField = DualityInterface.class.getDeclaredField("items");
            itemField.setAccessible(true);
            this.items = (MEMonitorPassThrough)itemField.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Couldn't get DualityInterface internal field, AE version seems incompatible!", e);
        }
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.updateProxiedPatterns();
        super.provideCrafting(craftingTracker);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        super.onChangeInventory(inv, slot, mc, removed, added);
        if (!(inv != this.getPatterns() || removed.func_190926_b() && added.func_190926_b())) {
            this.updateProxiedPatterns();
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        int i;
        NBTTagList taglist;
        super.readFromNBT(data);
        this.updateProxiedPatterns();
        if (data.func_74764_b("appliedfluidics.containers")) {
            taglist = data.func_150295_c("appliedfluidics.containers", 10);
            for (i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound ist = taglist.func_150305_b(i);
                ItemStack is = new ItemStack(ist);
                if (is.func_190926_b()) continue;
                this.returnContainers.add(is);
            }
        }
        if (data.func_74764_b("appliedfluidics.fluids")) {
            taglist = data.func_150295_c("appliedfluidics.fluids", 10);
            for (i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound fst = taglist.func_150305_b(i);
                FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fst);
                if (fs == null) continue;
                this.pendingFluids.add(fs);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagList tagList;
        super.writeToNBT(data);
        if (this.returnContainers.size() > 0) {
            tagList = new NBTTagList();
            for (ItemStack container : this.returnContainers) {
                tagList.func_74742_a((NBTBase)container.serializeNBT());
            }
            data.func_74782_a("appliedfluidics.containers", (NBTBase)tagList);
        }
        if (this.pendingFluids.size() > 0) {
            tagList = new NBTTagList();
            for (FluidStack fs : this.pendingFluids) {
                NBTTagCompound ftag = new NBTTagCompound();
                fs.writeToNBT(ftag);
                tagList.func_74742_a((NBTBase)ftag);
            }
            data.func_74782_a("appliedfluidics.fluids", (NBTBase)tagList);
        }
    }

    public void initialize() {
        super.initialize();
        this.updateProxiedPatterns();
    }

    public void addDrops(List<ItemStack> drops) {
        super.addDrops(drops);
        if (this.returnContainers.size() > 0) {
            drops.addAll(this.returnContainers);
        }
        if (this.pendingFluids.size() > 0) {
            for (FluidStack fs : this.pendingFluids) {
                ItemStack fluidDrop = ItemFluidDrop.getFilledDrop(fs);
                drops.add(fluidDrop);
            }
        }
    }

    private void updateProxiedPatterns() {
        List<ICraftingPatternDetails> craftingList = this.getCraftingList();
        if (craftingList == null) {
            return;
        }
        HashMap<ICraftingPatternDetails, PatternProxy> oldProxyPatterns = this.proxyPatterns;
        this.proxyPatterns = new HashMap(9);
        craftingList.removeIf(pattern -> pattern instanceof PatternProxy);
        ArrayList<PatternProxy> toAdd = new ArrayList<PatternProxy>();
        for (ICraftingPatternDetails src : craftingList) {
            if (oldProxyPatterns.containsKey(src)) {
                PatternProxy old = oldProxyPatterns.get(src);
                toAdd.add(old);
                this.proxyPatterns.put(src, old);
                continue;
            }
            if (!this.hasBuckets(src.getCondensedInputs())) continue;
            PatternProxy newProxy = new PatternProxy(src);
            toAdd.add(newProxy);
            this.proxyPatterns.put(src, newProxy);
        }
        craftingList.addAll(toAdd);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasWorkToDo(), true);
    }

    private boolean hasWorkToDo() {
        return this.pendingFluids.size() > 0 || this.returnContainers.size() > 0 || this.getWaitingToSend() != null && !this.getWaitingToSend().isEmpty();
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        List<ItemStack> waitingToSend;
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.pendingFluids.size() > 0) {
            Iterator<FluidStack> it = this.pendingFluids.iterator();
            while (it.hasNext()) {
                FluidStack fs = it.next();
                this.pushFluid(fs);
                if (fs.amount != 0) continue;
                it.remove();
            }
        }
        if (this.returnContainers.size() > 0) {
            ArrayList<ItemStack> old = this.returnContainers;
            this.returnContainers = new ArrayList();
            for (ItemStack is : old) {
                this.returnContainer(is);
            }
        }
        if ((waitingToSend = this.getWaitingToSend()) != null && !waitingToSend.isEmpty()) {
            Iterator<ItemStack> it = waitingToSend.iterator();
            while (it.hasNext()) {
                FluidStack fs;
                IFluidHandlerItem itemHandler;
                ItemStack is;
                is = it.next();
                if (is.func_190926_b() || is.func_77973_b() != ItemFluidDrop.INSTANCE && !BUCKETS.contains(is.func_77973_b()) || (itemHandler = FluidUtil.getFluidHandler((ItemStack)is)) == null || (fs = itemHandler.drain(Integer.MAX_VALUE, false)) == null) continue;
                FluidStack copy = fs.copy();
                this.pushFluid(copy);
                if (copy.amount >= fs.amount) continue;
                if (copy.amount > 0) {
                    this.pendingFluids.add(copy);
                }
                itemHandler.drain(fs, true);
                if (itemHandler.drain(Integer.MAX_VALUE, false) != null) continue;
                it.remove();
                ItemStack remainingItem = itemHandler.getContainer();
                if (remainingItem.func_190926_b()) continue;
                this.returnContainers.add(remainingItem);
            }
        }
        TickRateModulation superMod = super.tickingRequest(node, ticksSinceLastCall);
        return this.pendingFluids.size() > 0 || this.returnContainers.size() > 0 ? TickRateModulation.URGENT : superMod;
    }

    private void returnContainer(ItemStack container) {
        IAEItemStack rejected = (IAEItemStack)this.items.injectItems((IAEStack)AEApi.instance().storage().createItemStack(container), Actionable.MODULATE, (BaseActionSource)this.mySrc);
        if (rejected != null) {
            this.returnContainers.add(rejected.getItemStack());
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.hasItemsToSend() || !this.gridProxy.isActive() || !this.getCraftingList().contains(patternDetails)) {
            return false;
        }
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        EnumSet possibleDirections = this.iHost.getTargets();
        for (EnumFacing s : possibleDirections) {
            ICraftingMachine cm;
            TileEntity te;
            block16: {
                te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
                if (te == null) continue;
                if (te instanceof IInterfaceHost) {
                    try {
                        Method sameGrid = DualityInterface.class.getDeclaredMethod("sameGrid", IGrid.class);
                        sameGrid.setAccessible(true);
                        if (((Boolean)sameGrid.invoke((Object)((IInterfaceHost)te).getInterfaceDuality(), this.gridProxy.getGrid())).booleanValue()) {
                        }
                        break block16;
                    }
                    catch (GridAccessException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {}
                    continue;
                }
            }
            if (te instanceof ICraftingMachine && (cm = (ICraftingMachine)te).acceptsPlans()) {
                if (!cm.pushPattern(patternDetails, table, s.func_176734_d())) continue;
                return true;
            }
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, s.func_176734_d());
            InventoryAdaptor ad = InventoryAdaptor.getAdaptor((Object)te, (EnumFacing)s.func_176734_d());
            if (ad == null && fluidHandler == null || this.isBlocking() && ad != null && !ad.simulateRemove(1, null, null).func_190926_b() || !this.acceptsItems(ad, fluidHandler, table)) continue;
            for (int x = 0; x < table.func_70302_i_(); ++x) {
                FluidStack fs;
                IFluidHandlerItem itemHandler;
                ItemStack is = table.func_70301_a(x);
                if (is.func_190926_b()) continue;
                if (fluidHandler != null && (is.func_77973_b() == ItemFluidDrop.INSTANCE || BUCKETS.contains(is.func_77973_b())) && (itemHandler = FluidUtil.getFluidHandler((ItemStack)is)) != null && (fs = itemHandler.drain(Integer.MAX_VALUE, true)) != null) {
                    int filled;
                    if (is.func_190916_E() > 0) {
                        this.returnContainer(is);
                    }
                    if (is.func_190916_E() == 0) {
                        table.func_70299_a(x, ItemStack.field_190927_a);
                    }
                    if ((filled = fluidHandler.fill(fs, true)) == fs.amount) continue;
                    if (filled > 0) {
                        fs.amount -= filled;
                        this.pendingFluids.add(fs);
                        continue;
                    }
                    this.pendingFluids.add(fs);
                    continue;
                }
                if (ad != null) {
                    ItemStack added = ad.addItems(is);
                    this.addToSendList(added);
                    continue;
                }
                this.addToSendList(is);
            }
            this.pushItemsOut(possibleDirections);
            if (!this.pendingFluids.isEmpty()) {
                try {
                    this.gridProxy.getTick().alertDevice(this.gridProxy.getNode());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private void pushFluid(FluidStack fluid) {
        TileEntity tile = this.iHost.getTileEntity();
        World w = tile.func_145831_w();
        EnumSet possibleDirections = this.iHost.getTargets();
        for (EnumFacing s : possibleDirections) {
            TileEntity te = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
            if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, s.func_176734_d())) continue;
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, s.func_176734_d());
            int filled = fluidHandler.fill(fluid, true);
            fluid.amount -= filled;
            if (fluid.amount == 0) {
                return;
            }
            if (fluid.amount >= 0) continue;
            FluidicsMod.logger.error("Uhhhh, somehow I managed to file more that what was in the stack????");
            fluid.amount = 0;
            return;
        }
    }

    private boolean acceptsItems(InventoryAdaptor ad, IFluidHandler fluidHandler, InventoryCrafting table) {
        for (int x = 0; x < table.func_70302_i_(); ++x) {
            ItemStack is = table.func_70301_a(x);
            if (is.func_190926_b()) continue;
            if (fluidHandler != null && (is.func_77973_b() == ItemFluidDrop.INSTANCE || BUCKETS.contains(is.func_77973_b()))) {
                FluidStack fs = FluidUtil.getFluidContained((ItemStack)is);
                if (fs == null) {
                    return false;
                }
                int filled = fluidHandler.fill(fs, false);
                if (filled == fs.amount) continue;
            }
            if (ad != null && ad.simulateAdd(is.func_77946_l()).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String getTermName() {
        String superName = super.getTermName();
        if (!superName.equals("Nothing")) {
            return superName;
        }
        TileEntity hostTile = this.iHost.getTileEntity();
        World hostWorld = hostTile.func_145831_w();
        EnumSet possibleDirections = this.iHost.getTargets();
        for (EnumFacing direction : possibleDirections) {
            TileEntity directedTile;
            BlockPos targ;
            block10: {
                targ = hostTile.func_174877_v().func_177972_a(direction);
                directedTile = hostWorld.func_175625_s(targ);
                if (directedTile == null) continue;
                if (directedTile instanceof IInterfaceHost) {
                    try {
                        Method sameGrid = DualityInterface.class.getDeclaredMethod("sameGrid", IGrid.class);
                        sameGrid.setAccessible(true);
                        if (((Boolean)sameGrid.invoke((Object)((IInterfaceHost)directedTile).getInterfaceDuality(), this.gridProxy.getGrid())).booleanValue()) {
                        }
                        break block10;
                    }
                    catch (GridAccessException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {}
                    continue;
                }
            }
            if (!(directedTile instanceof ICraftingMachine) && !directedTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())) continue;
            IBlockState directedBlockState = hostWorld.func_180495_p(targ);
            Block directedBlock = directedBlockState.func_177230_c();
            ItemStack what = new ItemStack(directedBlock, 1, directedBlock.func_176201_c(directedBlockState));
            try {
                ItemStack g;
                Vec3d from = new Vec3d((double)hostTile.func_174877_v().func_177958_n() + 0.5, (double)hostTile.func_174877_v().func_177956_o() + 0.5, (double)hostTile.func_174877_v().func_177952_p() + 0.5);
                from = from.func_72441_c((double)direction.func_82601_c() * 0.501, (double)direction.func_96559_d() * 0.501, (double)direction.func_82599_e() * 0.501);
                Vec3d to = from.func_72441_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
                RayTraceResult mop = hostWorld.func_72901_a(from, to, true);
                if (mop != null && !BAD_BLOCKS.contains(directedBlock) && mop.func_178782_a().equals((Object)directedTile.func_174877_v()) && !(g = directedBlock.getPickBlock(directedBlockState, mop, hostWorld, directedTile.func_174877_v(), null)).func_190926_b()) {
                    what = g;
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.func_77973_b() != null) {
                return what.func_77977_a();
            }
            Item item = Item.func_150898_a((Block)directedBlock);
            if (item != null) continue;
            return directedBlock.func_149739_a();
        }
        return "Nothing (Fluid Interface)";
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.gridProxy.getGrid();
    }

    private List<ItemStack> getWaitingToSend() {
        try {
            Field waitingList = DualityInterface.class.getDeclaredField("waitingToSend");
            waitingList.setAccessible(true);
            return (List)waitingList.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    private boolean isBlocking() {
        return this.getConfigManager().getSetting(Settings.BLOCK) == YesNo.YES;
    }

    private void pushItemsOut(EnumSet<EnumFacing> possibleDirections) {
        try {
            Method pushItemsOut = DualityInterface.class.getDeclaredMethod("pushItemsOut", EnumSet.class);
            pushItemsOut.setAccessible(true);
            pushItemsOut.invoke((Object)this, possibleDirections);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void addToSendList(ItemStack is) {
        if (is.func_190926_b()) {
            return;
        }
        try {
            Method addToSendList = DualityInterface.class.getDeclaredMethod("addToSendList", ItemStack.class);
            addToSendList.setAccessible(true);
            addToSendList.invoke((Object)this, is);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected boolean hasItemsToSend() {
        try {
            Method hasItemsToSend = DualityInterface.class.getDeclaredMethod("hasItemsToSend", new Class[0]);
            hasItemsToSend.setAccessible(true);
            return (Boolean)hasItemsToSend.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return true;
        }
    }

    private boolean hasBuckets(IAEItemStack[] in) {
        for (IAEItemStack i : in) {
            if (!BUCKETS.contains(i.getItem())) continue;
            return true;
        }
        return false;
    }

    private List<ICraftingPatternDetails> getCraftingList() {
        try {
            Field craftingList = DualityInterface.class.getDeclaredField("craftingList");
            craftingList.setAccessible(true);
            return (List)craftingList.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return Collections.emptyList();
        }
    }

    private static class PatternProxy
    implements ICraftingPatternDetails {
        public ICraftingPatternDetails parent;
        private IAEItemStack[] myInputs;
        private IAEItemStack[] myInputsCondensed;

        public PatternProxy(ICraftingPatternDetails p) {
            this.parent = p;
            this.myInputs = this.exchangeBuckets(this.parent.getInputs());
            this.myInputsCondensed = this.exchangeBuckets(this.parent.getCondensedInputs());
        }

        public ItemStack getPattern() {
            return this.parent.getPattern();
        }

        public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
            return this.parent.isValidItemForSlot(slotIndex, itemStack, world);
        }

        public boolean isCraftable() {
            return this.parent.isCraftable();
        }

        public IAEItemStack[] getInputs() {
            return this.myInputs;
        }

        public IAEItemStack[] getCondensedInputs() {
            return this.myInputsCondensed;
        }

        public IAEItemStack[] getCondensedOutputs() {
            return this.parent.getCondensedOutputs();
        }

        public IAEItemStack[] getOutputs() {
            return this.parent.getOutputs();
        }

        public boolean canSubstitute() {
            return this.parent.canSubstitute();
        }

        public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
            return this.parent.getOutput(craftingInv, world);
        }

        public int getPriority() {
            return this.parent.getPriority() - 1;
        }

        public void setPriority(int priority) {
        }

        private IAEItemStack[] exchangeBuckets(IAEItemStack[] in) {
            IAEItemStack[] output = new IAEItemStack[in.length];
            for (int i = 0; i < in.length; ++i) {
                FluidStack fs;
                output[i] = in[i] != null && BUCKETS.contains(in[i].getItem()) && (fs = FluidUtil.getFluidContained((ItemStack)in[i].getItemStack())) != null ? (IAEItemStack)AEApi.instance().storage().createItemStack(ItemFluidDrop.getFilledDrop(fs)).setStackSize(in[i].getStackSize()) : in[i];
            }
            return output;
        }
    }
}

