/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.helpers;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.integration.Integrations;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import com.thiakil.appliedfluidics.helpers.FluidSorters;
import com.thiakil.appliedfluidics.item.ItemFluidViewCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidRepo {
    private IItemList<IAEFluidStack> list = AEApi.instance().storage().createFluidList();
    private final ArrayList<IAEFluidStack> view = new ArrayList();
    private final ArrayList<FluidStack> dsp = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private IPartitionList<IAEFluidStack> myPartitionList;
    private String innerSearch = "";
    private boolean hasPower;

    public FluidRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public IAEFluidStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public FluidStack getItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    void setSearch(String search) {
        this.searchString = search == null ? "" : search;
    }

    public void postUpdate(List<IAEFluidStack> list) {
        this.list = AEApi.instance().storage().createFluidList();
        for (IAEFluidStack st : list) {
            this.list.add((IAEStack)st);
        }
    }

    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemFluidViewCell.createFilter(list);
        this.updateView();
    }

    public void updateView() {
        this.updateView(true);
    }

    public void updateView(boolean updateJEI) {
        this.view.clear();
        this.dsp.clear();
        this.view.ensureCapacity(this.list.size());
        this.dsp.ensureCapacity(this.list.size());
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        if (updateJEI && (searchMode == SearchBoxMode.JEI_AUTOSEARCH || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH)) {
            this.updateJEI(this.searchString);
        }
        this.innerSearch = this.searchString;
        boolean terminalSearchToolTips = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_TOOLTIPS) != YesNo.NO;
        boolean searchMod = false;
        if (this.innerSearch.startsWith("@")) {
            searchMod = true;
            this.innerSearch = this.innerSearch.substring(1);
        }
        Pattern m = null;
        try {
            m = Pattern.compile(this.innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(this.innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        boolean notDone = false;
        block4: for (IAEFluidStack is : this.list) {
            if (this.myPartitionList != null && !this.myPartitionList.isListed((IAEStack)is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is = is.copy();
                is.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is.getStackSize() == 0L) continue;
            FluidStack fs = is.getFluidStack();
            String dspName = fs != null ? fs.getLocalizedName() : "NULL Fluidstack";
            notDone = true;
            if (m.matcher(dspName.toLowerCase()).find()) {
                this.view.add(is);
                notDone = false;
            }
            if (!terminalSearchToolTips || !notDone) continue;
            for (Object lp : Platform.getTooltip((Object)is)) {
                if (!(lp instanceof String) || !m.matcher((CharSequence)lp).find()) continue;
                this.view.add(is);
                notDone = false;
                continue block4;
            }
        }
        Enum SortBy = this.sortSrc.getSortBy();
        Enum SortDir2 = this.sortSrc.getSortDir();
        FluidSorters.setDirection((SortDir)SortDir2);
        FluidSorters.init();
        if (SortBy == SortOrder.MOD) {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_MOD);
        } else if (SortBy == SortOrder.AMOUNT) {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_SIZE);
        } else if (SortBy == SortOrder.INVTWEAKS) {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
        } else {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_NAME);
        }
        for (IAEFluidStack is : this.view) {
            this.dsp.add(is.getFluidStack());
        }
    }

    private void updateJEI(String filter) {
        Integrations.jei().setSearchText(filter);
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }
}

