/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.helpers;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEFluidStack;
import java.util.Comparator;

public class FluidSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_NAME = new Comparator<IAEFluidStack>(){

        @Override
        public int compare(IAEFluidStack o1, IAEFluidStack o2) {
            if (FluidSorters.getDirection() == SortDir.ASCENDING) {
                return o1.getFluidStack().getLocalizedName().compareToIgnoreCase(o2.getFluidStack().getLocalizedName());
            }
            return o2.getFluidStack().getLocalizedName().compareToIgnoreCase(o1.getFluidStack().getLocalizedName());
        }
    };
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_MOD = new Comparator<IAEFluidStack>(){

        @Override
        public int compare(IAEFluidStack o1, IAEFluidStack o2) {
            if (FluidSorters.getDirection() == SortDir.ASCENDING) {
                return this.secondarySort(o2.getFluid().getStill(o2.getFluidStack()).func_110624_b().compareToIgnoreCase(o1.getFluid().getStill(o1.getFluidStack()).func_110624_b()), o1, o2);
            }
            return this.secondarySort(o1.getFluid().getStill(o1.getFluidStack()).func_110624_b().compareToIgnoreCase(o2.getFluid().getStill(o2.getFluidStack()).func_110624_b()), o1, o2);
        }

        private int secondarySort(int compareToIgnoreCase, IAEFluidStack o1, IAEFluidStack o2) {
            if (compareToIgnoreCase == 0) {
                return o2.getFluidStack().getLocalizedName().compareToIgnoreCase(o1.getFluidStack().getLocalizedName());
            }
            return compareToIgnoreCase;
        }
    };
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_SIZE = new Comparator<IAEFluidStack>(){

        @Override
        public int compare(IAEFluidStack o1, IAEFluidStack o2) {
            if (FluidSorters.getDirection() == SortDir.ASCENDING) {
                return FluidSorters.compareLong(o2.getStackSize(), o1.getStackSize());
            }
            return FluidSorters.compareLong(o1.getStackSize(), o2.getStackSize());
        }
    };
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_INV_TWEAKS = new Comparator<IAEFluidStack>(){

        @Override
        public int compare(IAEFluidStack o1, IAEFluidStack o2) {
            return CONFIG_BASED_SORT_BY_NAME.compare(o1, o2);
        }
    };

    public static void init() {
    }

    public static int compareInt(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareLong(long a, long b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareDouble(double a, double b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }
}

