/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.item;

import com.thiakil.appliedfluidics.item.AFBaseItem;
import com.thiakil.appliedfluidics.util.FluidColours;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidDrop
extends AFBaseItem {
    public static final int CAPACITY = 1000;
    public static ItemFluidDrop INSTANCE;

    public ItemFluidDrop() {
        super("fluiddrop");
        this.func_77625_d(1);
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack);
    }

    @Nullable
    public static FluidStack getFluidStackFromStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77978_p() != null) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
        }
        return null;
    }

    @Nullable
    public static Fluid getFluidFromStack(ItemStack stack) {
        FluidStack fs = ItemFluidDrop.getFluidStackFromStack(stack);
        if (fs != null) {
            return fs.getFluid();
        }
        return null;
    }

    public static ItemStack getFilledDrop(Fluid fluid) {
        return ItemFluidDrop.getFilledDrop(new FluidStack(fluid, 1000));
    }

    public static ItemStack getFilledDrop(FluidStack fs) {
        NBTTagCompound itemTag = new NBTTagCompound();
        NBTTagCompound fluidTag = new NBTTagCompound();
        fs.writeToNBT(fluidTag);
        itemTag.func_74782_a("Fluid", (NBTBase)fluidTag);
        ItemStack outStack = new ItemStack((Item)INSTANCE, 1, 0);
        outStack.func_77982_d(itemTag);
        return outStack;
    }

    public boolean func_77645_m() {
        return false;
    }

    @Nullable
    public static ItemStack newDropDrainFluidStack(FluidStack fs) {
        if (fs == null || fs.amount < 1000) {
            return ItemStack.field_190927_a;
        }
        FluidStack dropFluid = fs.copy();
        ItemStack newDrop = ItemFluidDrop.getFilledDrop(dropFluid);
        if (!newDrop.func_190926_b()) {
            fs.amount -= 1000;
            return newDrop;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack f = ItemFluidDrop.getFluidStackFromStack(stack);
        if (f != null) {
            return f.getFluid().getLocalizedName(f);
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void setInstance(AFBaseItem instance) {
        INSTANCE = (ItemFluidDrop)instance;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ItemFluidDrop.getAllDrops(subItems);
        }
    }

    public static void getAllDrops(List<ItemStack> outList) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack stack = ItemFluidDrop.getFilledDrop(fluid);
            if (stack.func_190926_b()) continue;
            outList.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColorHandler() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            FluidStack fs;
            if (tintIndex == 0 && (fs = ItemFluidDrop.getFluidStackFromStack(stack)) != null) {
                return FluidColours.getColor(fs);
            }
            return -1;
        }, new Item[]{this});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        FluidStack fs = ItemFluidDrop.getFluidStackFromStack(stack);
        if (fs == null) {
            tooltip.add(TextFormatting.RED + "This item is not valid. It is missing NBT describing a fluid. Report as a bug to the mod that created it!");
            return;
        }
        tooltip.add(I18n.func_135052_a((String)"appliedfluidics.fluiddrop.desc.1", (Object[])new Object[]{fs.amount, fs.getLocalizedName()}));
        tooltip.add(I18n.func_135052_a((String)"appliedfluidics.fluiddrop.desc.2", (Object[])new Object[0]));
    }

    public static class FluidHandler
    extends FluidHandlerItemStackSimple.Consumable {
        public FluidHandler(ItemStack itemStack) {
            super(itemStack, 1000);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.capacity, false, true)};
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack ret = super.drain(maxDrain, doDrain);
            return ret;
        }
    }
}

