/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.contents.CellUpgrades;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventory;
import com.thiakil.appliedfluidics.handlers.IFluidicCellInventoryHandler;
import com.thiakil.appliedfluidics.item.AFBaseItem;
import com.thiakil.appliedfluidics.item.FluidCellConfig;
import com.thiakil.appliedfluidics.item.IFluidicStorageCell;
import com.thiakil.appliedfluidics.item.ItemMaterial;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public final class ItemFluidicStorageCell
extends AFBaseItem
implements IFluidicStorageCell,
IItemGroup {
    private static final String ITEM_ID = "fluid_storage_cell";
    public static ItemFluidicStorageCell INSTANCE;

    public ItemFluidicStorageCell() {
        super(ITEM_ID);
        this.func_77625_d(1);
    }

    private CellCapacity getCellInfo(ItemStack is) {
        int id = is.func_77960_j();
        if (id < 0 || id > CellCapacity.values().length) {
            id = 0;
        }
        return CellCapacity.values()[id];
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        this.func_77627_a(true);
        super.registerItem(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (CellCapacity type : CellCapacity.values()) {
                items.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag displayMoreInfo) {
        IFluidicCellInventoryHandler handler;
        IFluidicCellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof IFluidicCellInventoryHandler && (cellInventory = (handler = (IFluidicCellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cellInventory.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cellInventory.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
            if (handler.isPreformatted()) {
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                if (handler.isFuzzy()) {
                    lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Fuzzy.getLocal());
                } else {
                    lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                }
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + this.getCellInfo((ItemStack)stack).langName;
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.getCellInfo((ItemStack)cellItem).totalBytes;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.getCellInfo((ItemStack)cellItem).perType;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 63;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain(ItemStack cellItem) {
        return this.getCellInfo((ItemStack)cellItem).idleDrain;
    }

    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new FluidCellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.disassembleDrive(stack, world, player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean disassembleDrive(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (EnumFacing)EnumFacing.UP);
                IItemList list = inv.getAvailableItems(StorageChannel.FLUIDS.createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, ItemStack.field_190927_a);
                    ItemStack extraB = ia.addItems(this.getCellInfo((ItemStack)stack).component.stack(1));
                    if (!extraB.func_190926_b()) {
                        player.func_71019_a(extraB, false);
                    }
                    IInventory upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.func_70302_i_(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.func_70301_a(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack.func_190926_b() || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
                        ItemStack extraA = ia.addItems(is);
                        if (!extraA.func_190926_b()) {
                            player.func_71019_a(extraA, false);
                        }
                    });
                    ItemStack chipRej = ia.addItems(new ItemStack((Item)ItemMaterial.INSTANCE, 1, ItemMaterial.Material.PROCESSOR_FLUID.ordinal()));
                    if (!chipRej.func_190926_b()) {
                        player.func_71019_a(chipRej, false);
                    }
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.disassembleDrive(player.func_184586_b(hand), world, player) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return (ItemStack)AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).orElseThrow(() -> new MissingDefinition("Tried to use empty storage cells while basic storage cells are defined."));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_DISASSEMBLY_CRAFTING);
    }

    @Override
    public void setInstance(AFBaseItem instance) {
        INSTANCE = (ItemFluidicStorageCell)instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemRender() {
        for (CellCapacity type : CellCapacity.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)type.ordinal(), (ModelResourceLocation)new ModelResourceLocation(type.resourceName, "inventory"));
        }
    }

    private static enum CellCapacity {
        CELL_1K(MaterialType.Cell1kPart, 1),
        CELL_4K(MaterialType.Cell4kPart, 4),
        CELL_16K(MaterialType.Cell16kPart, 16),
        CELL_64K(MaterialType.Cell64kPart, 64);

        public final MaterialType component;
        public final int totalBytes;
        public final int perType;
        public final double idleDrain;
        public final int kB;
        public final String resourceName;
        public final String langName;

        private CellCapacity(MaterialType component, int kilobytes) {
            this.totalBytes = kilobytes * 1024;
            this.component = component;
            this.kB = kilobytes;
            this.resourceName = "appliedfluidics:fluid_storage_cell_" + this.kB + "k";
            this.langName = "appliedfluidics.fluid_storage_cell_" + this.kB + "k";
            switch (this.component) {
                case Cell1kPart: {
                    this.idleDrain = 0.5;
                    this.perType = 8;
                    break;
                }
                case Cell4kPart: {
                    this.idleDrain = 1.0;
                    this.perType = 32;
                    break;
                }
                case Cell16kPart: {
                    this.idleDrain = 1.5;
                    this.perType = 128;
                    break;
                }
                case Cell64kPart: {
                    this.idleDrain = 2.0;
                    this.perType = 512;
                    break;
                }
                default: {
                    this.idleDrain = 0.0;
                    this.perType = 8;
                }
            }
        }
    }
}

