/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.item;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.features.IInscriberRegistry;
import appeng.api.features.InscriberProcessType;
import com.thiakil.appliedfluidics.item.AFBaseItem;
import java.util.Collections;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemMaterial
extends AFBaseItem {
    public static ItemMaterial INSTANCE;

    public ItemMaterial() {
        super("material");
    }

    @Override
    public void setInstance(AFBaseItem instance) {
        INSTANCE = (ItemMaterial)instance;
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        this.func_77627_a(true);
        super.registerItem(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Material type : Material.values()) {
                items.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemRender() {
        for (Material type : Material.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)type.ordinal(), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("appliedfluidics", type.name), "inventory"));
        }
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta >= Material.values().length) {
            return "invalid meta";
        }
        return "item." + Material.values()[meta].getLangName();
    }

    @Override
    public void postInit() {
        super.postInit();
        IDefinitions defs = AEApi.instance().definitions();
        IInscriberRegistry registry = AEApi.instance().registries().inscriber();
        registry.addRecipe(registry.builder().withInputs(Collections.singletonList(new ItemStack(Items.field_179562_cC))).withOutput(new ItemStack((Item)this, 1, Material.PROCESSOR_FLUID_PRINTED.ordinal())).withTopOptional(new ItemStack((Item)this, 1, Material.PROCESSOR_FLUID_PRESS.ordinal())).withProcessType(InscriberProcessType.INSCRIBE).build());
        registry.addRecipe(registry.builder().withInputs(Collections.singletonList(new ItemStack(Items.field_151137_ax))).withOutput(new ItemStack((Item)this, 1, Material.PROCESSOR_FLUID.ordinal())).withTopOptional(new ItemStack((Item)this, 1, Material.PROCESSOR_FLUID_PRINTED.ordinal())).withBottomOptional(defs.materials().siliconPrint().maybeStack(1).orElse(ItemStack.field_190927_a)).withProcessType(InscriberProcessType.PRESS).build());
        if (defs.materials().engProcessorPrint().isEnabled()) {
            registry.addRecipe(registry.builder().withInputs(Collections.singletonList(new ItemStack(Blocks.field_180397_cI))).withOutput(new ItemStack((Item)this, 1, Material.PROCESSOR_FLUID_PRESS.ordinal())).withTopOptional((ItemStack)defs.materials().engProcessorPrint().maybeStack(1).get()).withProcessType(InscriberProcessType.PRESS).build());
        }
    }

    public static enum Material {
        PROCESSOR_FLUID("processor_fluid"),
        PROCESSOR_FLUID_PRESS("processor_fluid_press"),
        PROCESSOR_FLUID_PRINTED("processor_fluid_printed");

        public String name;

        private Material(String name) {
            this.name = name;
        }

        public String getResourceName() {
            return "appliedfluidics:" + this.name;
        }

        public String getLangName() {
            return "appliedfluidics." + this.name;
        }
    }
}

