/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.item;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.client.render.StaticItemColor;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.item.AFBaseItem;
import com.thiakil.appliedfluidics.part.FluidicsPartType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemPart
extends AFBaseItem
implements IPartItem<IPart> {
    public static ItemPart INSTANCE;
    public static Map<FluidicsPartType, ItemStack> itemStackMap;
    @SideOnly(value=Side.CLIENT)
    private static StaticItemColor aeColor;

    public ItemPart() {
        super("item_part");
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return FluidicsPartType.getPart(stack).getUnlocalizedName();
        }
        catch (NullPointerException e) {
            return "appliedfluidics.item_part.invalid";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.addAll(itemStackMap.values());
        }
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        this.func_77627_a(true);
        itemStackMap = new HashMap<FluidicsPartType, ItemStack>(FluidicsPartType.values().length);
        for (FluidicsPartType type : FluidicsPartType.values()) {
            itemStackMap.put(type, new ItemStack((Item)this, 1, type.ordinal()));
        }
        super.registerItem(registry);
    }

    @Override
    public void registerItemRender() {
        for (FluidicsPartType type : FluidicsPartType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)type.ordinal(), (ModelResourceLocation)new ModelResourceLocation(type.getPartItemLocation(), "inventory"));
        }
    }

    @Nullable
    public IPart createPartFromItemStack(ItemStack is) {
        try {
            IPart part = FluidicsPartType.getPart(is).newInstance(is);
            FluidicsMod.logger.debug("Created part {}", part.getClass());
            return part;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack is = player.func_184586_b(hand);
        return is.func_77960_j() >= 0 && is.func_77960_j() < FluidicsPartType.values().length ? AEApi.instance().partHelper().placeBus(is, pos, side, player, hand, w) : EnumActionResult.FAIL;
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    @Override
    public void postInit() {
        super.postInit();
        for (FluidicsPartType type : FluidicsPartType.values()) {
            Map<Upgrades, Integer> upgrades = type.getUpgrades();
            upgrades.forEach((upgrade, max) -> upgrade.registerItem(new ItemStack((Item)this, 1, type.ordinal()), max.intValue()));
        }
    }

    @Override
    public void setInstance(AFBaseItem instance) {
        INSTANCE = (ItemPart)instance;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColorHandler() {
        aeColor = new StaticItemColor(AEColor.TRANSPARENT);
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)aeColor, new Item[]{this});
    }
}

