/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.item;

import com.thiakil.appliedfluidics.client.render.ModelQuartzBucket;
import com.thiakil.appliedfluidics.item.AFBaseItem;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class QuartzBucket
extends AFBaseItem {
    public static QuartzBucket CERTUS_QUARTZ_BUCKET;
    public static QuartzBucket NETHER_QUARTZ_BUCKET;
    private String variant;
    private final int capacity;

    protected QuartzBucket(String variant) {
        super("quartz_bucket_" + variant);
        this.capacity = 1000;
        this.variant = variant;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    @Override
    public void setInstance(AFBaseItem instance) {
        if (instance instanceof QuartzBucket) {
            String vari = ((QuartzBucket)instance).variant;
            if (vari.equals("nether")) {
                NETHER_QUARTZ_BUCKET = (QuartzBucket)instance;
            } else if (vari.equals("certus")) {
                CERTUS_QUARTZ_BUCKET = (QuartzBucket)instance;
            }
        }
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        if (this.getFluid(itemStack) != null) {
            return new ItemStack((Item)this);
        }
        return super.getContainerItem(itemStack);
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this));
        Iterator iterator = FluidRegistry.getRegisteredFluids().values().iterator();
        while (iterator.hasNext()) {
            ItemStack stack = new ItemStack((Item)this);
            FluidHandlerItemStackSimple fluidHandler = new FluidHandlerItemStackSimple(stack, this.capacity);
            Fluid fluid = (Fluid)iterator.next();
            FluidStack fs = new FluidStack(fluid, this.getCapacity());
            if (fluidHandler.fill(fs, true) != fs.amount) continue;
            ItemStack filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        String unloc = this.func_77657_g(stack);
        return I18n.func_74837_a((String)(unloc + ".filled"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        ItemStack itemstack = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos clickPos = mop.func_178782_a();
        if (world.func_175660_a(player, clickPos) && player.func_175151_a(targetPos = clickPos.func_177972_a(mop.field_178784_b), mop.field_178784_b, itemstack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)itemstack, (FluidStack)fluidStack)).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            ItemStack emptyStack;
            player.func_71029_a(StatList.func_188057_b((Item)this));
            itemstack.func_190918_g(1);
            ItemStack drained = result.getResult();
            ItemStack itemStack = emptyStack = !drained.func_190926_b() ? drained.func_77946_l() : new ItemStack((Item)this);
            if (itemstack.func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)emptyStack);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        return new FluidHandlerItemStackSimple(container, this.capacity).getFluid();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStackSimple(stack, this.capacity);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getFluid(stack) != null ? 1 : super.getItemStackLimit(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemRender() {
        ModelResourceLocation loc = this.variant.equals("nether") ? ModelQuartzBucket.LOCATION_NETHER : ModelQuartzBucket.LOCATION_CERTUS;
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelQuartzBucket.LoaderQuartzBucket.INSTANCE);
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> loc);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{loc});
    }

    public static class NetherBucket
    extends QuartzBucket {
        public NetherBucket() {
            super("nether");
        }
    }

    public static class CertusBucket
    extends QuartzBucket {
        public CertusBucket() {
            super("certus");
        }
    }
}

