/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.network;

import appeng.api.storage.data.IAEFluidStack;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.client.gui.GuiMEMonitorableFluid;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFluidMEInventoryUpdate
implements IMessage {
    private final List<IAEFluidStack> list = new LinkedList<IAEFluidStack>();
    private byte ref;
    private boolean empty = true;

    public void fromBytes(ByteBuf stream) {
        try {
            while (stream.readableBytes() > 0) {
                this.list.add(NBTAwareAEFluidStack.loadFluidStackFromPacket(stream));
            }
        }
        catch (IOException e) {
            FluidicsMod.logger.error("Error decoding packet", (Throwable)e);
        }
        this.empty = this.list.isEmpty();
    }

    public void appendItem(IAEFluidStack is) {
        this.list.add(is);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void toBytes(ByteBuf buf) {
        boolean ref = false;
        for (IAEFluidStack stack : this.list) {
            try {
                stack.writeToPacket(buf);
            }
            catch (IOException e) {
                FluidicsMod.logger.error("Error encoding packet", (Throwable)e);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketFluidMEInventoryUpdate, IMessage> {
        public IMessage onMessage(PacketFluidMEInventoryUpdate message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
                if (gs instanceof GuiMEMonitorableFluid) {
                    ((GuiMEMonitorableFluid)gs).postUpdate(message.list);
                }
            });
            return null;
        }
    }
}

