/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.network;

import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.container.ContainerFluidStorageBus;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStorageBusAction
implements IMessage {
    private ActionType action;

    public PacketStorageBusAction(ActionType action) {
        this.action = action;
    }

    public PacketStorageBusAction() {
        this.action = ActionType.INVALID;
    }

    public void fromBytes(ByteBuf stream) {
        byte packetVal = stream.readByte();
        this.action = packetVal > 0 && packetVal < ActionType.values().length ? ActionType.values()[packetVal] : ActionType.INVALID;
    }

    public ActionType getAction() {
        return this.action;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.action.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketStorageBusAction, IMessage> {
        public IMessage onMessage(PacketStorageBusAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                Container openContainer = ctx.getServerHandler().field_147369_b.field_71070_bA;
                if (openContainer instanceof ContainerFluidStorageBus) {
                    switch (message.action) {
                        case PARTITION: {
                            ((ContainerFluidStorageBus)openContainer).partition();
                            break;
                        }
                        case CLEAR: {
                            ((ContainerFluidStorageBus)openContainer).clear();
                            break;
                        }
                        default: {
                            FluidicsMod.logger.error("Invalid storage bus packet received :/");
                        }
                    }
                }
            });
            return null;
        }
    }

    public static enum ActionType {
        INVALID,
        PARTITION,
        CLEAR;

    }
}

