/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.config.Upgrades;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartModels;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModel;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.ModItems;
import com.thiakil.appliedfluidics.client.render.BuiltInModelLoader;
import com.thiakil.appliedfluidics.item.ItemPart;
import com.thiakil.appliedfluidics.part.IPartHasCustomModels;
import com.thiakil.appliedfluidics.part.PartAdvancedInterfaceTerminal;
import com.thiakil.appliedfluidics.part.PartFluidAnnihilationPlane;
import com.thiakil.appliedfluidics.part.PartFluidExport;
import com.thiakil.appliedfluidics.part.PartFluidFormationPlane;
import com.thiakil.appliedfluidics.part.PartFluidImport;
import com.thiakil.appliedfluidics.part.PartFluidInterface;
import com.thiakil.appliedfluidics.part.PartFluidLevelEmitter;
import com.thiakil.appliedfluidics.part.PartFluidStorage;
import com.thiakil.appliedfluidics.part.PartFluidTerminal;
import com.thiakil.appliedfluidics.part.PlaneModels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class FluidicsPartType
extends Enum<FluidicsPartType> {
    public static final /* enum */ FluidicsPartType FLUIDSTORAGE = new FluidicsPartType("fluid_storage", PartFluidStorage.class, FluidicsPartType.generatePair(Upgrades.INVERTER, 1), FluidicsPartType.generatePair(Upgrades.FUZZY, 1), FluidicsPartType.generatePair(Upgrades.CAPACITY, 5));
    public static final /* enum */ FluidicsPartType IMPORTBUS = new FluidicsPartType("fluid_import_bus", PartFluidImport.class, FluidicsPartType.generatePair(Upgrades.REDSTONE, 1), FluidicsPartType.generatePair(Upgrades.CAPACITY, 2), FluidicsPartType.generatePair(Upgrades.SPEED, 4), FluidicsPartType.generatePair(Upgrades.FUZZY, 1));
    public static final /* enum */ FluidicsPartType EXPORTBUS = new FluidicsPartType("fluid_export_bus", PartFluidExport.class, FluidicsPartType.generatePair(Upgrades.REDSTONE, 1), FluidicsPartType.generatePair(Upgrades.CAPACITY, 2), FluidicsPartType.generatePair(Upgrades.SPEED, 4), FluidicsPartType.generatePair(Upgrades.FUZZY, 1));
    public static final /* enum */ FluidicsPartType FORMATIONPLANE = new FluidicsPartType("fluid_formation_plane", PartFluidFormationPlane.class, FluidicsPartType.generatePair(Upgrades.CAPACITY, 5), FluidicsPartType.generatePair(Upgrades.INVERTER, 1), FluidicsPartType.generatePair(Upgrades.FUZZY, 1));
    public static final /* enum */ FluidicsPartType FLUID_TERMINAL = new FluidicsPartType("fluid_terminal", PartFluidTerminal.class);
    public static final /* enum */ FluidicsPartType ANNIHILATIONPLANE = new FluidicsPartType("fluid_annihilation_plane", PartFluidAnnihilationPlane.class);
    public static final /* enum */ FluidicsPartType LEVEL_EMITTER = new FluidicsPartType("fluid_level_emitter", PartFluidLevelEmitter.class, FluidicsPartType.generatePair(Upgrades.FUZZY, 1));
    public static final /* enum */ FluidicsPartType INTERFACE = new FluidicsPartType("fluid_interface", PartFluidInterface.class, FluidicsPartType.generatePair(Upgrades.CRAFTING, 1));
    public static final /* enum */ FluidicsPartType INTERFACE_TERMINAL = new FluidicsPartType("advanced_interface_terminal", PartAdvancedInterfaceTerminal.class);
    @SideOnly(value=Side.CLIENT)
    private static BuiltInModelLoader loaderInstance;
    private String unlocalizedName;
    private ResourceLocation partItemLocation;
    private Class<? extends IPart> partClass;
    private Map<Upgrades, Integer> upgrades = new HashMap<Upgrades, Integer>();
    private static final /* synthetic */ FluidicsPartType[] $VALUES;

    public static FluidicsPartType[] values() {
        return (FluidicsPartType[])$VALUES.clone();
    }

    public static FluidicsPartType valueOf(String name) {
        return Enum.valueOf(FluidicsPartType.class, name);
    }

    private FluidicsPartType(String _unlocalizedName, Class<? extends IPart> _partClass) {
        this.unlocalizedName = "appliedfluidics.part." + _unlocalizedName;
        this.partClass = _partClass;
        this.partItemLocation = new ResourceLocation("appliedfluidics", "parts/" + _unlocalizedName);
    }

    private FluidicsPartType(String _unlocalizedName, Class<? extends IPart> _partClass, Pair<Upgrades, Integer> ... _upgrades) {
        this.unlocalizedName = "appliedfluidics.part." + _unlocalizedName;
        this.partClass = _partClass;
        this.partItemLocation = new ResourceLocation("appliedfluidics", "parts/" + _unlocalizedName);
        for (Pair<Upgrades, Integer> pair : _upgrades) {
            this.upgrades.put((Upgrades)pair.getKey(), (Integer)pair.getValue());
        }
    }

    private static Pair<Upgrades, Integer> generatePair(Upgrades _upgrade, int max) {
        return new MutablePair((Object)_upgrade, (Object)max);
    }

    public static int getPartID(Class<? extends IPart> partClass) {
        for (int i = 0; i < FluidicsPartType.values().length; ++i) {
            if (FluidicsPartType.values()[i].getPartClass() != partClass) continue;
            return i;
        }
        return -1;
    }

    public static FluidicsPartType getPart(ItemStack is) {
        assert (is.func_77973_b() == ModItems.getInstance(ItemPart.class));
        if (is.func_77960_j() < FluidicsPartType.values().length && is.func_77960_j() >= 0) {
            return FluidicsPartType.values()[is.func_77960_j()];
        }
        FluidicsMod.logger.error("ItemPart meta is wrong!");
        return null;
    }

    public static int getPartID(IPart partFluidBase) {
        return FluidicsPartType.getPartID(partFluidBase.getClass());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerPartModels(IPartModels modelsRegistry) {
        for (FluidicsPartType type : FluidicsPartType.values()) {
            try {
                IPart part;
                ItemStack partStack = ItemPart.itemStackMap.get((Object)type);
                if (partStack.func_190926_b() || (part = ItemPart.INSTANCE.createPartFromItemStack(partStack)) == null || !(part instanceof IPartHasCustomModels)) continue;
                modelsRegistry.registerModels(((IPartHasCustomModels)part).getModelsToRegister());
            }
            catch (Exception partStack) {
                // empty catch block
            }
        }
        modelsRegistry.registerModels(new ResourceLocation[]{PlaneModels.MODEL_CHASSIS_HAS_CHANNEL, PlaneModels.MODEL_CHASSIS_OFF, PlaneModels.MODEL_CHASSIS_ON});
        ResourceLocation annihilationPlaneTexture = new ResourceLocation("appliedenergistics2", "items/part/annihilation_plane");
        ResourceLocation annihilationPlaneOnTexture = new ResourceLocation("appliedenergistics2", "parts/annihilation_plane_on");
        ResourceLocation formationPlaneTexture = new ResourceLocation("appliedfluidics", "parts/fluid_formation_plane");
        ResourceLocation formationPlaneOnTexture = new ResourceLocation("appliedfluidics", "parts/fluid_formation_plane_on");
        ResourceLocation sidesTexture = new ResourceLocation("appliedfluidics", "parts/fluid_plane_sides");
        ResourceLocation backTexture = new ResourceLocation("appliedfluidics", "parts/fluid_transition_plane_back");
        HashMap<String, IModel> builtInModels = new HashMap<String, IModel>();
        try {
            ArrayList<String> modelNames = new ArrayList<String>();
            for (PlaneConnections connection : PlaneConnections.PERMUTATIONS) {
                PlaneModel model = new PlaneModel(annihilationPlaneTexture, sidesTexture, backTexture, connection);
                builtInModels.put("models/part/fluid_annihilation_plane_" + connection.getFilenameSuffix(), (IModel)model);
                modelNames.add("part/fluid_annihilation_plane_" + connection.getFilenameSuffix());
                model = new PlaneModel(annihilationPlaneOnTexture, sidesTexture, backTexture, connection);
                builtInModels.put("models/part/fluid_annihilation_plane_on_" + connection.getFilenameSuffix(), (IModel)model);
                modelNames.add("part/fluid_annihilation_plane_on_" + connection.getFilenameSuffix());
                model = new PlaneModel(formationPlaneTexture, sidesTexture, backTexture, connection);
                builtInModels.put("models/part/fluid_formation_plane_" + connection.getFilenameSuffix(), (IModel)model);
                modelNames.add("part/fluid_formation_plane_" + connection.getFilenameSuffix());
                model = new PlaneModel(formationPlaneOnTexture, sidesTexture, backTexture, connection);
                builtInModels.put("models/part/fluid_formation_plane_on_" + connection.getFilenameSuffix(), (IModel)model);
                modelNames.add("part/fluid_formation_plane_on_" + connection.getFilenameSuffix());
            }
            List partResourceLocs = modelNames.stream().map(name -> new ResourceLocation("appliedfluidics", name)).collect(Collectors.toList());
            modelsRegistry.registerModels(partResourceLocs);
            loaderInstance = new BuiltInModelLoader(builtInModels);
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)loaderInstance);
        }
        catch (Exception e) {
            FluidicsMod.logger.debug("Couldn't register built ins", (Throwable)e);
        }
    }

    public Class<? extends IPart> getPartClass() {
        return this.partClass;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public ResourceLocation getPartItemLocation() {
        return this.partItemLocation;
    }

    public Map<Upgrades, Integer> getUpgrades() {
        return this.upgrades;
    }

    public IPart newInstance(ItemStack partStack) {
        try {
            IPart partFluidBase = this.partClass.getConstructor(ItemStack.class).newInstance(partStack);
            return partFluidBase;
        }
        catch (Exception e) {
            FluidicsMod.logger.fatal("Could not instantiate part", (Throwable)e);
            return null;
        }
    }

    public ItemStack getStack() {
        return new ItemStack((Item)ItemPart.INSTANCE, 1, this.ordinal());
    }

    static {
        $VALUES = new FluidicsPartType[]{FLUIDSTORAGE, IMPORTBUS, EXPORTBUS, FORMATIONPLANE, FLUID_TERMINAL, ANNIHILATIONPLANE, LEVEL_EMITTER, INTERFACE, INTERFACE_TERMINAL};
    }
}

