/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartBasicState;
import appeng.parts.automation.PlaneConnections;
import appeng.tile.storage.TileIOPort;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.CommonProxy;
import com.thiakil.appliedfluidics.part.PlaneModels;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PartFluidAnnihilationPlane
extends PartBasicState
implements IGridTickable,
ICellContainer,
IMEInventoryHandler<IAEFluidStack> {
    private static final PlaneModels MODELS = new PlaneModels("part/fluid_annihilation_plane_", "part/fluid_annihilation_plane_on_");
    private final BaseActionSource mySrc = new MachineSource((IActionHost)this);
    private World myWorld;
    private BlockPos facingBlock;
    private boolean wasActive = false;
    private boolean hadInfWater = false;
    private IAEFluidStack maxIntWater = new NBTAwareAEFluidStack(new FluidStack(FluidRegistry.WATER, 0)).setCountRequestable(Integer.MAX_VALUE);
    private IAEFluidStack negMaxIntWater = new NBTAwareAEFluidStack(new FluidStack(FluidRegistry.WATER, 0)).setCountRequestable(-2147483647L);
    private static Map<UUID, Integer> cowCooldown = new HashMap<UUID, Integer>();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartFluidAnnihilationPlane(ItemStack is) {
        super(is);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            EnumFacing e = bch.getWorldX();
            EnumFacing u = bch.getWorldY();
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e.func_176734_d())), this.getSide())) {
                minX = false;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxX = 16;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u.func_176734_d())), this.getSide())) {
                minY = false;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, (double)maxX, (double)maxY, bch.isBBCollision() ? 15.0 : 16.0);
    }

    public PlaneConnections getConnections() {
        EnumFacing facingUp;
        EnumFacing facingRight;
        AEPartLocation location = this.getSide();
        switch (location) {
            case UP: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case DOWN: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case NORTH: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.UP;
                break;
            }
            case SOUTH: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.UP;
                break;
            }
            case WEST: {
                facingRight = EnumFacing.SOUTH;
                facingUp = EnumFacing.UP;
                break;
            }
            case EAST: {
                facingRight = EnumFacing.NORTH;
                facingUp = EnumFacing.UP;
                break;
            }
            default: {
                return PlaneConnections.of((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight.func_176734_d())), this.getSide())) {
                left = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight)), this.getSide())) {
                right = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp.func_176734_d())), this.getSide())) {
                down = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp)), this.getSide())) {
                up = true;
            }
        }
        return PlaneConnections.of((boolean)up, (boolean)right, (boolean)down, (boolean)left);
    }

    public void onNeighborChanged() {
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getTick().alertDevice(this.getProxy().getNode());
                if (this.wasActive) {
                    boolean facingWater = this.facingPermanentWaterSource();
                    if (!this.hadInfWater && facingWater) {
                        IItemList list = AEApi.instance().storage().createFluidList();
                        list.add((IAEStack)this.maxIntWater.copy());
                        this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.FLUIDS, (Iterable)list, this.mySrc);
                        this.hadInfWater = true;
                    } else if (this.hadInfWater && !facingWater) {
                        IItemList list = AEApi.instance().storage().createFluidList();
                        list.add((IAEStack)this.negMaxIntWater.copy());
                        this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.FLUIDS, (Iterable)list, this.mySrc);
                        this.hadInfWater = false;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    protected boolean isAnnihilationPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == ((Object)((Object)this)).getClass();
        }
        return false;
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.onNeighborChanged();
        this.getHost().markForUpdate();
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onNeighborChanged();
        this.getHost().markForUpdate();
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        List cows;
        if (!this.getProxy().isActive() || !this.canHandleBlock(this.myWorld, this.facingBlock)) {
            return TickRateModulation.IDLE;
        }
        boolean worked = false;
        IBlockState state = this.myWorld.func_180495_p(this.facingBlock);
        if (state.func_185904_a().func_76224_d()) {
            boolean isWaterSource;
            Fluid blockFluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
            NBTAwareAEFluidStack slurped = new NBTAwareAEFluidStack(new FluidStack(blockFluid, 1000));
            boolean bl = isWaterSource = blockFluid == FluidRegistry.WATER && this.hasSiblingWaterBlocks(2);
            if (!this.hadInfWater && isWaterSource) {
                this.myWorld.func_175685_c(this.getTile().func_174877_v(), state.func_177230_c(), true);
            }
            if (!isWaterSource) {
                try {
                    IMEMonitor inv = this.getProxy().getStorage().getFluidInventory();
                    IEnergyGrid energy = this.getProxy().getEnergy();
                    IAEFluidStack rejected = (IAEFluidStack)inv.injectItems((IAEStack)slurped, Actionable.SIMULATE, this.mySrc);
                    if (rejected == null && FluidPlatform.capAmountByPowerAvailable(1000L, (IEnergySource)energy) == 1000L && ((rejected = FluidPlatform.poweredInsert((IEnergySource)energy, (IMEInventory<IAEFluidStack>)inv, slurped, this.mySrc)) == null || rejected.getStackSize() < 1000L)) {
                        worked = true;
                        this.myWorld.func_175698_g(this.facingBlock);
                        FluidPlatform.playFluidSoundAt(this.myWorld, this.facingBlock, blockFluid, true);
                    }
                }
                catch (GridAccessException inv) {}
            }
        } else if (CommonProxy.gotMilk != null && (cows = this.myWorld.func_72872_a(EntityCow.class, new AxisAlignedBB(this.facingBlock))).size() > 0) {
            try {
                int maxCows;
                IMEMonitor inv = this.getProxy().getStorage().getFluidInventory();
                FluidStack milk = new FluidStack(CommonProxy.gotMilk, 0);
                IAEFluidStack rejects = (IAEFluidStack)inv.injectItems((IAEStack)new NBTAwareAEFluidStack(milk).setStackSize(cows.size() * 1000), Actionable.SIMULATE, this.mySrc);
                if (rejects == null) {
                    maxCows = cows.size();
                } else {
                    maxCows = cows.size() - (int)rejects.getStackSize() / 1000;
                    if (rejects.getStackSize() % 1000L > 0L) {
                        --maxCows;
                    }
                }
                if (maxCows > 0) {
                    int usedCows = 0;
                    for (EntityCow cow : cows) {
                        if (cow.func_70631_g_() || cowCooldown.containsKey(cow.func_110124_au()) && cow.field_70173_aa - cowCooldown.get(cow.func_110124_au()) < 60) continue;
                        milk.amount += 1000;
                        cowCooldown.put(cow.func_110124_au(), cow.field_70173_aa);
                        if (++usedCows != maxCows) continue;
                        break;
                    }
                }
                if (milk.amount > 0) {
                    NBTAwareAEFluidStack aeMilk = new NBTAwareAEFluidStack(milk);
                    IEnergyGrid energy = this.getProxy().getEnergy();
                    IAEFluidStack rejected = (IAEFluidStack)inv.injectItems((IAEStack)aeMilk, Actionable.SIMULATE, this.mySrc);
                    if (rejected == null && ((rejected = FluidPlatform.poweredInsert((IEnergySource)energy, (IMEInventory<IAEFluidStack>)inv, aeMilk, this.mySrc)) == null || rejected.getStackSize() < aeMilk.getStackSize())) {
                        worked = true;
                        this.myWorld.func_184133_a(null, this.facingBlock, SoundEvents.field_187564_an, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return worked ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private boolean hasSiblingWaterBlocks(int required) {
        int siblings = 0;
        for (EnumFacing sibling : EnumFacing.field_176754_o) {
            BlockPos siblingPos = this.facingBlock.func_177972_a(sibling);
            if (this.myWorld.func_180495_p(siblingPos).func_177230_c() == FluidRegistry.WATER.getBlock()) {
                ++siblings;
            }
            if (siblings != required) continue;
            return true;
        }
        return false;
    }

    private boolean canHandleBlock(World w, BlockPos pos) {
        IBlockState state = w.func_180495_p(pos);
        Material material = state.func_185904_a();
        List cows = w.func_72872_a(EntityCow.class, new AxisAlignedBB(pos));
        if (!(cows.size() > 0 || w.func_175667_e(pos) && !w.func_175623_d(pos) && material.func_76224_d())) {
            return false;
        }
        Block fluidBlock = state.func_177230_c();
        Fluid blockFluid = FluidRegistry.lookupFluidForBlock((Block)fluidBlock);
        if (blockFluid == null && cows.size() <= 0) {
            return false;
        }
        if (cows.size() > 0) {
            return true;
        }
        if (fluidBlock instanceof BlockLiquid ? (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 : fluidBlock instanceof BlockFluidBase && (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) != 0) {
            return false;
        }
        return w.canMineBlockBody(Platform.getPlayer((WorldServer)((WorldServer)w)), pos);
    }

    private boolean facingPermanentWaterSource() {
        if (!this.canHandleBlock(this.myWorld, this.facingBlock)) {
            return false;
        }
        IBlockState state = this.myWorld.func_180495_p(this.facingBlock);
        Fluid blockFluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
        return blockFluid == FluidRegistry.WATER && this.hasSiblingWaterBlocks(2);
    }

    public void addToWorld() {
        super.addToWorld();
        TileEntity te = this.getTile();
        this.myWorld = te.func_145831_w();
        this.facingBlock = te.func_174877_v().func_177972_a(this.getSide().getFacing());
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.getConnections(), this.isPowered(), this.isActive());
    }

    public void blinkCell(int slot) {
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> ret = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.FLUIDS) {
            ret.add(this);
        }
        return ret;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    public boolean canAccept(IAEFluidStack input) {
        return false;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return false;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request.getFluid() != FluidRegistry.WATER || !this.facingPermanentWaterSource() || src instanceof MachineSource && ((MachineSource)src).via instanceof TileIOPort) {
            return null;
        }
        try {
            IEnergyGrid energy = this.getProxy().getEnergy();
            long maxSend = FluidPlatform.capAmountByPowerAvailable(request.getStackSize() * 2L, (IEnergySource)energy) / 2L;
            if (mode == Actionable.MODULATE) {
                maxSend = FluidPlatform.extractPowerForAmount(maxSend * 2L, (IEnergySource)energy) / 2L;
            }
            return (IAEFluidStack)request.copy().setStackSize(maxSend);
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.facingPermanentWaterSource()) {
            out.addRequestable((IAEStack)this.maxIntWater.copy());
            this.hadInfWater = true;
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public void saveChanges(IMEInventory cellInventory) {
    }
}

