/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.part.IPartHasCustomModels;
import com.thiakil.appliedfluidics.part.PartSharedFluidBus;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import com.thiakil.appliedfluidics.util.FluidicList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PartFluidExport
extends PartSharedFluidBus
implements IPartHasCustomModels {
    private final BaseActionSource mySrc;
    private boolean didSomething = false;
    private int nextSlot = 0;
    private int fluidToSend;
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedfluidics", "parts/fluid_export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/export_bus_has_channel")});

    public PartFluidExport(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.mySrc = new MachineSource((IActionHost)this);
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.didSomething = false;
        IFluidHandler destination = this.getFluidHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (destination != null) {
            try {
                this.fluidToSend = this.calculateFluidToSend();
                IMEMonitor inv = this.getProxy().getStorage().getFluidInventory();
                IEnergyGrid energy = this.getProxy().getEnergy();
                SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
                int x = 0;
                block2: for (x = 0; x < this.availableSlots() && this.fluidToSend > 0; ++x) {
                    int slotToExport = this.getStartingSlot(schedulingMode, x);
                    IAEFluidStack ais = this.getConfig().getAEFluidStackInSlot(slotToExport);
                    if (ais == null || this.fluidToSend <= 0) continue;
                    long before = this.fluidToSend;
                    if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                        for (IAEFluidStack o : FluidicList.findFuzzy((IItemList<IAEFluidStack>)inv.getStorageList(), ais, fzMode)) {
                            this.pushFluidIntoTarget(destination, energy, (IMEInventory<IAEFluidStack>)inv, o);
                            if (this.fluidToSend > 0) continue;
                            continue block2;
                        }
                        continue;
                    }
                    this.pushFluidIntoTarget(destination, energy, (IMEInventory<IAEFluidStack>)inv, ais);
                }
                this.updateSchedulingMode(schedulingMode, x);
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private void pushFluidIntoTarget(IFluidHandler d, IEnergyGrid energy, IMEInventory<IAEFluidStack> inv, IAEFluidStack ais) {
        FluidStack is = ais.getFluidStack();
        is.amount = this.fluidToSend;
        long canFit = d.fill(is, false);
        if (canFit > 0L) {
            ais = ais.copy();
            ais.setStackSize(canFit);
            IAEFluidStack itemsToAdd = FluidPlatform.poweredExtraction((IEnergySource)energy, inv, ais, this.mySrc);
            if (itemsToAdd != null) {
                this.fluidToSend = (int)((long)this.fluidToSend - itemsToAdd.getStackSize());
                int filled = d.fill(itemsToAdd.getFluidStack(), true);
                long failed = itemsToAdd.getStackSize() - (long)filled;
                if (failed > 0L) {
                    ais.setStackSize(failed);
                    inv.injectItems((IAEStack)ais, Actionable.MODULATE, this.mySrc);
                }
                this.didSomething = true;
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.nextSlot = extra.func_74762_e("nextSlot");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        extra.func_74768_a("nextSlot", this.nextSlot);
    }

    private int getStartingSlot(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.RANDOM) {
            return Platform.getRandom().nextInt(this.availableSlots());
        }
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            return (this.nextSlot + x) % this.availableSlots();
        }
        return x;
    }

    private void updateSchedulingMode(SchedulingMode schedulingMode, int x) {
        if (schedulingMode == SchedulingMode.ROUNDROBIN) {
            this.nextSlot = (this.nextSlot + x) % this.availableSlots();
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    @Nonnull
    public ResourceLocation[] getModelsToRegister() {
        return new ResourceLocation[]{MODEL_BASE};
    }
}

