/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.PartFormationPlane;
import appeng.parts.automation.PlaneConnections;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.PrecisePriorityList;
import com.thiakil.appliedfluidics.part.PartFluidUpgradeable;
import com.thiakil.appliedfluidics.part.PlaneModels;
import com.thiakil.appliedfluidics.util.FluidConfigInventory;
import com.thiakil.appliedfluidics.util.FluidGuiBridge;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import com.thiakil.appliedfluidics.util.FuzzyFluidPriorityList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PartFluidFormationPlane
extends PartFluidUpgradeable
implements ICellContainer,
IPriorityHost,
IMEInventory<IAEFluidStack> {
    private static final PlaneModels MODELS = new PlaneModels("part/fluid_formation_plane_", "part/fluid_formation_plane_on_");
    private final MEInventoryHandler<IAEFluidStack> myHandler = new MEInventoryHandler((IMEInventory)this, StorageChannel.FLUIDS);
    private final FluidConfigInventory Config = new FluidConfigInventory((IAEAppEngInventory)this, 63);
    private int priority = 0;
    private boolean wasActive = false;
    private boolean blocked = false;
    private static final int POWER_USE = 2;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartFluidFormationPlane(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.updateHandler();
    }

    private void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.priority);
        IItemList priorityList = AEApi.instance().storage().createFluidList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.Config.func_70302_i_() && x < slotsToUse; ++x) {
            IAEFluidStack is = this.Config.getAEFluidStackInSlot(x);
            if (is == null) continue;
            priorityList.add((IAEStack)is);
        }
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.myHandler.setPartitionList((IPartitionList)new FuzzyFluidPriorityList((IItemList<IAEFluidStack>)priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
        } else {
            this.myHandler.setPartitionList((IPartitionList)new PrecisePriorityList(priorityList));
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateHandler();
        this.getHost().markForSave();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.updateHandler();
        }
    }

    public void upgradesChanged() {
        this.updateHandler();
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.priority = data.func_74762_e("priority");
        this.updateHandler();
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
        data.func_74768_a("priority", this.priority);
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            EnumFacing e = bch.getWorldX();
            EnumFacing u = bch.getWorldY();
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e.func_176734_d())), this.getSide())) {
                minX = false;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxX = 16;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u.func_176734_d())), this.getSide())) {
                minY = false;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u)), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, (double)maxX, (double)maxY, 16.0);
    }

    public PlaneConnections getConnections() {
        EnumFacing facingUp;
        EnumFacing facingRight;
        AEPartLocation location = this.getSide();
        switch (location) {
            case UP: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case DOWN: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case NORTH: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.UP;
                break;
            }
            case SOUTH: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.UP;
                break;
            }
            case WEST: {
                facingRight = EnumFacing.SOUTH;
                facingUp = EnumFacing.UP;
                break;
            }
            case EAST: {
                facingRight = EnumFacing.NORTH;
                facingUp = EnumFacing.UP;
                break;
            }
            default: {
                return PlaneConnections.of((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight.func_176734_d())), this.getSide())) {
                left = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight)), this.getSide())) {
                right = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp.func_176734_d())), this.getSide())) {
                down = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp)), this.getSide())) {
                up = true;
            }
        }
        return PlaneConnections.of((boolean)up, (boolean)right, (boolean)down, (boolean)left);
    }

    public void onNeighborChanged() {
        TileEntity te = this.getHost().getTile();
        World w = te.func_145831_w();
        AEPartLocation side = this.getSide();
        BlockPos tePos = te.func_174877_v().func_177972_a(side.getFacing());
        this.blocked = !w.func_180495_p(tePos).func_177230_c().func_176200_f((IBlockAccess)w, tePos);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            FluidGuiBridge.openGUI(player, this.getHost().getTile(), this.getSide(), FluidGuiBridge.FLUID_FORMATION_PLANE);
            return true;
        }
        return false;
    }

    private boolean isTransitionPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p instanceof PartFormationPlane;
        }
        return false;
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive() && channel == StorageChannel.FLUIDS) {
            ArrayList<IMEInventoryHandler> Handler2 = new ArrayList<IMEInventoryHandler>(1);
            Handler2.add((IMEInventoryHandler)this.myHandler);
            return Handler2;
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.updateHandler();
    }

    public void blinkCell(int slot) {
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        if (this.blocked || input == null || input.getStackSize() < 1000L || !input.getFluid().canBePlacedInWorld()) {
            return input;
        }
        boolean worked = false;
        long maxStorage = 1000L;
        try {
            if (FluidPlatform.capAmountByPowerAvailable(2L, (IEnergySource)this.getProxy().getEnergy()) == 2L) {
                if (type == Actionable.SIMULATE) {
                    worked = true;
                } else {
                    this.getProxy().getEnergy().extractAEPower(2.0, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    FluidStack fs = input.getFluidStack();
                    if (this.myWorld.func_175623_d(this.facingBlock)) {
                        worked = FluidUtil.tryPlaceFluid(null, (World)this.myWorld, (BlockPos)this.facingBlock, (IFluidHandler)new PlaceFluidHandler(fs), (FluidStack)fs);
                        IBlockState state = this.myWorld.func_180495_p(this.facingBlock);
                        if (worked) {
                            state.func_177230_c().func_189540_a(state, this.myWorld, this.facingBlock, state.func_177230_c(), this.getLocation().getPos());
                        }
                    }
                    this.blocked = !this.myWorld.func_175623_d(this.facingBlock);
                }
            }
        }
        catch (GridAccessException e) {
            worked = false;
        }
        if (worked) {
            IAEFluidStack out = input.copy();
            out.decStackSize(maxStorage);
            if (out.getStackSize() == 0L) {
                return null;
            }
            return out;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        return null;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public void saveChanges(IMEInventory cellInventory) {
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.getConnections(), this.isPowered(), this.isActive());
    }

    private class PlaceFluidHandler
    implements IFluidHandler {
        private FluidStack contents;

        PlaceFluidHandler(FluidStack contents) {
            this.contents = contents;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.contents;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.contents;
        }
    }
}

