/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.part.IPartHasCustomModels;
import com.thiakil.appliedfluidics.part.PartSharedFluidBus;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PartFluidImport
extends PartSharedFluidBus
implements IPartHasCustomModels {
    private boolean worked;
    private int fluidToSend;
    private final BaseActionSource source = new MachineSource((IActionHost)this);
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedfluidics", "parts/fluid_import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_has_channel")});
    private IMEMonitor<IAEFluidStack> destination = null;

    public PartFluidImport(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.worked = false;
        IFluidHandler myAdaptor = this.getFluidHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                this.fluidToSend = this.calculateFluidToSend();
                IMEMonitor inv = this.getProxy().getStorage().getFluidInventory();
                IEnergyGrid energy = this.getProxy().getEnergy();
                boolean Configured = false;
                for (int x = 0; x < this.availableSlots(); ++x) {
                    IAEFluidStack afs = this.getConfig().getAEFluidStackInSlot(x);
                    if (afs == null || this.fluidToSend <= 0) continue;
                    Configured = true;
                    while (this.fluidToSend > 0 && !this.importStuff(myAdaptor, afs, (IMEMonitor<IAEFluidStack>)inv, (IEnergySource)energy, fzMode)) {
                    }
                }
                if (!Configured) {
                    while (this.fluidToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, (IMEMonitor<IAEFluidStack>)inv, (IEnergySource)energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private boolean importStuff(IFluidHandler myAdaptor, IAEFluidStack whatToImport, IMEMonitor<IAEFluidStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        FluidStack wantedFS;
        boolean IMPORT_STUFF_NO_MORE_WORK = true;
        if (whatToImport == null) {
            wantedFS = myAdaptor.drain(1000, false);
            if (wantedFS == null) {
                return true;
            }
            wantedFS = wantedFS.copy();
        } else {
            wantedFS = whatToImport.getFluidStack();
            if (fzMode != FuzzyMode.IGNORE_ALL && myAdaptor.drain(wantedFS, false) == null) {
                IFluidTankProperties[] tanks = myAdaptor.getTankProperties();
                if (tanks == null) {
                    return true;
                }
                Fluid searchFluid = wantedFS.getFluid();
                boolean foundFluid = false;
                for (IFluidTankProperties tank : tanks) {
                    FluidStack contents;
                    if (!tank.canDrain() || (contents = tank.getContents()) == null || contents.getFluid() != searchFluid) continue;
                    wantedFS = contents;
                    foundFluid = true;
                    break;
                }
                if (!foundFluid) {
                    return true;
                }
            }
        }
        int toSend = this.calculateMaximumAmountToImport(myAdaptor, wantedFS, inv, fzMode);
        if (toSend == 0) {
            return true;
        }
        wantedFS.amount = toSend;
        FluidStack drained = null;
        drained = myAdaptor.drain(wantedFS, true);
        if (drained == null) {
            return true;
        }
        this.fluidToSend -= drained.amount;
        this.worked = true;
        IAEFluidStack rejects = FluidPlatform.poweredInsert(energy, inv, new NBTAwareAEFluidStack(drained), this.source);
        if (rejects != null) {
            int handlerRejects = (int)rejects.getStackSize() - myAdaptor.fill(rejects.getFluidStack(), true);
            if (handlerRejects > 0) {
                FluidicsMod.logger.error("Could not re-insert failed amount into handler! " + handlerRejects + "mb will be lost!");
                FluidicsMod.logger.error("This should only ever happen if AE power extraction fails when simulation succeeded.");
            }
            return true;
        }
        return false;
    }

    private int calculateMaximumAmountToImport(IFluidHandler myAdaptor, FluidStack whatToImport, IMEMonitor<IAEFluidStack> inv, FuzzyMode fzMode) {
        if (whatToImport == null) {
            return 0;
        }
        whatToImport.amount = this.fluidToSend;
        if (this.configDestination(inv).canAccept((IAEStack)new NBTAwareAEFluidStack(whatToImport))) {
            FluidStack simResult = myAdaptor.drain(whatToImport, false);
            if (simResult == null) {
                return 0;
            }
            IAEFluidStack itemAmountNotStorable = (IAEFluidStack)this.configDestination(inv).injectItems((IAEStack)new NBTAwareAEFluidStack(simResult), Actionable.SIMULATE, this.source);
            if (itemAmountNotStorable != null) {
                return (int)Math.min((long)simResult.amount - itemAmountNotStorable.getStackSize(), (long)this.fluidToSend);
            }
            return simResult.amount;
        }
        return 0;
    }

    private IMEMonitor<IAEFluidStack> configDestination(IMEMonitor<IAEFluidStack> fluidInventory) {
        this.destination = fluidInventory;
        return this.destination;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    @Nonnull
    public ResourceLocation[] getModelsToRegister() {
        return new ResourceLocation[]{MODEL_BASE};
    }
}

