/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.part.PartFluidUpgradeable;
import com.thiakil.appliedfluidics.util.FluidConfigInventory;
import com.thiakil.appliedfluidics.util.FluidGuiBridge;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PartFluidLevelEmitter
extends PartFluidUpgradeable
implements IStackWatcherHost,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    @PartModels
    public static final ResourceLocation MODEL_BASE_OFF = new ResourceLocation("appliedenergistics2", "part/level_emitter_base_off");
    @PartModels
    public static final ResourceLocation MODEL_BASE_ON = new ResourceLocation("appliedenergistics2", "part/level_emitter_base_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_OFF = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_off");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_ON = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_HAS_CHANNEL = new ResourceLocation("appliedenergistics2", "part/level_emitter_status_has_channel");
    public static final PartModel MODEL_OFF_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE_OFF, MODEL_STATUS_OFF});
    public static final PartModel MODEL_OFF_ON = new PartModel(new ResourceLocation[]{MODEL_BASE_OFF, MODEL_STATUS_ON});
    public static final PartModel MODEL_OFF_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE_OFF, MODEL_STATUS_HAS_CHANNEL});
    public static final PartModel MODEL_ON_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE_ON, MODEL_STATUS_OFF});
    public static final PartModel MODEL_ON_ON = new PartModel(new ResourceLocation[]{MODEL_BASE_ON, MODEL_STATUS_ON});
    public static final PartModel MODEL_ON_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE_ON, MODEL_STATUS_HAS_CHANNEL});
    private static final int FLAG_ON = 4;
    private final FluidConfigInventory config = new FluidConfigInventory((IAEAppEngInventory)this, 1);
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher myWatcher;
    private double centerX;
    private double centerY;
    private double centerZ;

    public PartFluidLevelEmitter(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, (Enum)RedstoneMode.HIGH_SIGNAL);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        this.updateState();
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            TileEntity te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (BlockPos)te.func_174877_v());
            Platform.notifyBlocksOfNeighbors((World)te.func_145831_w(), (BlockPos)te.func_174877_v().func_177972_a(this.getSide().getFacing()));
        }
    }

    private boolean isLevelEmitterOn() {
        boolean flipState;
        if (Platform.isClient()) {
            return (this.getClientFlags() & 4) == 4;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 4 : 0);
    }

    private void configureWatchers() {
        IAEFluidStack myStack = this.config.getAEFluidStackInSlot(0);
        if (this.myWatcher != null) {
            this.myWatcher.reset();
        }
        try {
            if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0 || myStack == null) {
                this.getProxy().getStorage().getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, (Object)this.getProxy().getGrid());
            } else {
                this.getProxy().getStorage().getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
                if (this.myWatcher != null) {
                    this.myWatcher.add((IAEStack)myStack);
                }
            }
            this.updateReportingValue((IMEMonitor<IAEFluidStack>)this.getProxy().getStorage().getFluidInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEFluidStack> monitor) {
        IAEFluidStack myStack = this.config.getAEFluidStackInSlot(0);
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEFluidStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            Collection fuzzyList = monitor.getStorageList().findFuzzy((IAEStack)myStack, fzMode);
            for (IAEFluidStack st : fuzzyList) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEFluidStack r = (IAEFluidStack)monitor.getStorageList().findPrecise((IAEStack)myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (chan == StorageChannel.FLUIDS && fullStack.equals((Object)this.config.getAEFluidStackInSlot(0)) && this.getInstalledUpgrades(Upgrades.FUZZY) == 0) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        this.updateReportingValue((IMEMonitor<IAEFluidStack>)((IMEMonitor)monitor));
    }

    public void onListUpdate() {
        try {
            this.updateReportingValue((IMEMonitor<IAEFluidStack>)this.getProxy().getStorage().getFluidInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    public void randomDisplayTick(World world, BlockPos pos, Random r) {
        if (this.isLevelEmitterOn()) {
            AEPartLocation d = this.getSide();
            double d0 = (double)((float)d.xOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.yOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.zOffset * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_175688_a(EnumParticleTypes.REDSTONE, 0.5 + (double)pos.func_177958_n() + d0, 0.5 + (double)pos.func_177956_o() + d1, 0.5 + (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            FluidGuiBridge.openGUI(player, this.getHost().getTile(), this.getSide(), FluidGuiBridge.LEVEL_EMITTER);
            return true;
        }
        return false;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.configureWatchers();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    public void upgradesChanged() {
        this.configureWatchers();
    }

    public boolean canConnectRedstone() {
        return true;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.func_74763_f("lastReportedValue");
        this.reportingValue = data.func_74763_f("reportingValue");
        this.prevState = data.func_74767_n("prevState");
        this.config.readFromNBT(data, "config");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("lastReportedValue", this.lastReportedValue);
        data.func_74772_a("reportingValue", this.reportingValue);
        data.func_74757_a("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_HAS_CHANNEL : MODEL_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? MODEL_ON_ON : MODEL_OFF_ON;
        }
        return this.isLevelEmitterOn() ? MODEL_ON_OFF : MODEL_OFF_OFF;
    }
}

