/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageHelper;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.settings.TickRates;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.FluidList;
import appeng.util.prioritylist.IPartitionList;
import appeng.util.prioritylist.PrecisePriorityList;
import com.thiakil.appliedfluidics.part.IPartHasCustomModels;
import com.thiakil.appliedfluidics.part.PartFluidUpgradeable;
import com.thiakil.appliedfluidics.util.FluidConfigInventory;
import com.thiakil.appliedfluidics.util.FluidDropWrapper;
import com.thiakil.appliedfluidics.util.FluidGuiBridge;
import com.thiakil.appliedfluidics.util.FuzzyFluidPriorityList;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PartFluidStorage
extends PartFluidUpgradeable
implements ICellContainer,
IMEInventoryHandler<IAEFluidStack>,
IGridTickable,
IPriorityHost,
IPartHasCustomModels,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    private static IStorageHelper aeStorage = AEApi.instance().storage();
    private int priority;
    private boolean wasActive = false;
    private IPartitionList<IAEFluidStack> myPartitionList;
    private IncludeExclude partitionMode;
    private IItemList<IAEFluidStack> fluidCache = aeStorage.createFluidList();
    private IStorageMonitorable externalStorage;
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedfluidics", "parts/fluid_storage_bus_base");
    public static final ResourceLocation[] MODELS_TO_LOAD = new ResourceLocation[]{MODEL_BASE};
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/storage_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/storage_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/storage_bus_has_channel")});
    private final FluidConfigInventory config = new FluidConfigInventory((IAEAppEngInventory)this, 63);
    private boolean cacheValid = false;
    private MachineSource mySrc = new MachineSource((IActionHost)this);

    public PartFluidStorage(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (this.getProxy().isActive()) {
            if (channel == StorageChannel.FLUIDS) {
                list.add(this);
            }
            this.updateFluidCache(false);
        }
        return list;
    }

    public AccessRestriction getAccess() {
        return (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS);
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return this.partitionAccepts(input) && this.fluidCache.findPrecise((IAEStack)input) != null;
    }

    public boolean canAccept(IAEFluidStack input) {
        return ((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS)).hasPermission(AccessRestriction.WRITE) && this.partitionAccepts(input) && (this.externalStorage == null || this.externalStorage.getFluidInventory() != null && this.externalStorage.getFluidInventory().canAccept((IAEStack)input));
    }

    private void updatePartition() {
        this.partitionMode = this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        FluidList priorityList = new FluidList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.config.func_70302_i_() && x < slotsToUse; ++x) {
            IAEFluidStack is = this.config.getAEFluidStackInSlot(x);
            if (is == null) continue;
            priorityList.add((IAEStack)is);
        }
        this.myPartitionList = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? new FuzzyFluidPriorityList((IItemList<IAEFluidStack>)priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)) : new PrecisePriorityList((IItemList)priorityList);
    }

    private boolean partitionAccepts(@Nonnull FluidStack input) {
        return this.partitionAccepts(new NBTAwareAEFluidStack(input));
    }

    private boolean partitionAccepts(@Nonnull IAEFluidStack input) {
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler == null && this.externalStorage == null) {
            return false;
        }
        IAEFluidStack inputClamped = input.copy();
        inputClamped.setStackSize(1000L);
        if (this.myPartitionList == null || !this.cacheValid) {
            this.updatePartition();
        }
        if (this.partitionMode == IncludeExclude.BLACKLIST && this.myPartitionList.isListed((IAEStack)inputClamped)) {
            return false;
        }
        if (this.myPartitionList.isEmpty() || this.partitionMode == IncludeExclude.BLACKLIST) {
            return fluidHandler == null || this.handlerCanAccept(fluidHandler, inputClamped);
        }
        return this.myPartitionList.isListed((IAEStack)inputClamped) && (fluidHandler == null || this.handlerCanAccept(fluidHandler, inputClamped)) && (this.externalStorage == null || this.externalStorage.getFluidInventory() != null && this.externalStorage.getFluidInventory().canAccept((IAEStack)input));
    }

    private boolean handlerCanAccept(IFluidHandler fluidHandler, IAEFluidStack input) {
        FluidStack inputFS = input.getFluidStack();
        if (inputFS == null) {
            return false;
        }
        for (IFluidTankProperties tank : fluidHandler.getTankProperties()) {
            if (!tank.canFillFluidType(inputFS)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public void saveChanges(IMEInventory cellInventory) {
    }

    public void blinkCell(int slot) {
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        if (!this.getProxy().isActive()) {
            return input;
        }
        if (this.externalStorage != null) {
            return this.externalStorage.getFluidInventory() != null ? (IAEFluidStack)this.externalStorage.getFluidInventory().injectItems((IAEStack)input, type, src) : input;
        }
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler == null) {
            return input;
        }
        int filled = fluidHandler.fill(input.getFluidStack(), type == Actionable.MODULATE);
        if ((long)filled == input.getStackSize()) {
            return null;
        }
        IAEFluidStack result = input.copy();
        result.setStackSize(input.getStackSize() - (long)filled);
        if (type == Actionable.MODULATE) {
            this.cacheValid = false;
        }
        return result;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (!this.getProxy().isActive()) {
            return null;
        }
        if (this.externalStorage != null) {
            return this.externalStorage.getFluidInventory() != null ? (IAEFluidStack)this.externalStorage.getFluidInventory().extractItems((IAEStack)request, mode, src) : null;
        }
        if (this.cacheValid && this.fluidCache.findPrecise((IAEStack)request) == null) {
            return null;
        }
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler != null) {
            FluidStack drained = fluidHandler.drain(request.getFluidStack(), mode == Actionable.MODULATE);
            if (mode == Actionable.MODULATE) {
                this.cacheValid = false;
            }
            return drained != null ? new NBTAwareAEFluidStack(drained) : null;
        }
        return null;
    }

    private boolean updateFluidCache(boolean checkChange) {
        this.updatePartition();
        IItemList<IAEFluidStack> oldCache = this.fluidCache;
        this.fluidCache = aeStorage.createFluidList();
        StorageFilter extractMode = (StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER);
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler != null) {
            IFluidTankProperties[] tanks;
            for (IFluidTankProperties tank : tanks = fluidHandler.getTankProperties()) {
                FluidStack content = tank.getContents();
                boolean canExtract = tank.canDrain();
                if (content == null || !this.partitionAccepts(content) || extractMode == StorageFilter.EXTRACTABLE_ONLY && !canExtract) continue;
                this.fluidCache.add((IAEStack)new NBTAwareAEFluidStack(content));
            }
        }
        ArrayList changes = new ArrayList();
        oldCache.forEach(stack -> {
            IAEFluidStack cfr_ignored_0 = (IAEFluidStack)stack.setStackSize(-stack.getStackSize());
        });
        this.fluidCache.forEach(newStack -> {
            IAEFluidStack old = (IAEFluidStack)oldCache.findPrecise((IAEStack)newStack);
            if (old == null) {
                changes.add(newStack);
            } else {
                old.add(newStack);
                if (old.getStackSize() != 0L) {
                    changes.add(old);
                }
            }
        });
        oldCache.forEach(oldStack -> {
            if (this.fluidCache.findPrecise((IAEStack)oldStack) == null) {
                changes.add(oldStack);
            }
        });
        if (changes.size() > 0) {
            try {
                this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.FLUIDS, changes, (BaseActionSource)this.mySrc);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.cacheValid = true;
        return changes.size() > 0;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        block5: {
            block4: {
                if (!((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS)).hasPermission(AccessRestriction.READ)) {
                    return out;
                }
                if (this.externalStorage != null) break block4;
                if (!this.cacheValid) {
                    this.updateFluidCache(false);
                }
                for (IAEFluidStack fs : this.fluidCache) {
                    out.add((IAEStack)fs);
                }
                break block5;
            }
            if (this.externalStorage.getFluidInventory() == null) break block5;
            IItemList extList = this.externalStorage.getFluidInventory().getStorageList();
            for (IAEFluidStack fs : extList) {
                if (!this.partitionAccepts(fs)) continue;
                out.add((IAEStack)fs);
            }
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        this.updateStatus();
    }

    public void onNeighborChanged() {
        this.updateStatus();
    }

    private void updateStatus() {
        boolean currentActive = this.getProxy().isActive();
        if (this.externalStorage != null) {
            this.externalStorage.getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
        }
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.externalStorage = this.checkInterface();
                if (this.externalStorage == null) {
                    this.updateFluidCache(false);
                }
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                this.getHost().markForUpdate();
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.externalStorage = this.checkInterface();
        }
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus.getMin(), TickRates.StorageBus.getMax(), false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.updateFluidCache(true)) {
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    @Nullable
    public IMEInventoryHandler<IAEItemStack> getInternalHandler() {
        try {
            return new FluidDropWrapper(this, (IEnergySource)this.getProxy().getGrid().getCache(IEnergyGrid.class));
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            FluidGuiBridge.openGUI(player, this.getHost().getTile(), this.getSide(), FluidGuiBridge.FLUID_STORAGE_BUS);
            return true;
        }
        return false;
    }

    protected FluidConfigInventory getConfig() {
        return this.config;
    }

    public FluidConfigInventory getFluidConfig() {
        return this.config;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.getConfig();
        }
        return super.getInventoryByName(name);
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.config.readFromNBT(data, "config");
        this.priority = data.func_74762_e("priority");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.config.writeToNBT(data, "config");
        data.func_74768_a("priority", this.priority);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.config) {
            this.updateFluidCache(false);
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.getHost().markForUpdate();
        }
    }

    @Override
    @Nonnull
    public ResourceLocation[] getModelsToRegister() {
        return MODELS_TO_LOAD;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateFluidCache(false);
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.getHost().markForUpdate();
        this.getHost().markForSave();
    }

    public boolean isValid(Object verificationToken) {
        return verificationToken == this;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.FLUIDS, change, (BaseActionSource)this.mySrc);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void onListUpdate() {
    }

    @Nullable
    protected IStorageMonitorable checkInterface() {
        if (this.myWorld == null) {
            return null;
        }
        TileEntity facingTile = this.myWorld.func_175625_s(this.facingBlock);
        if (facingTile != null && facingTile.hasCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, this.getSide().getFacing().func_176734_d())) {
            IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)facingTile.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, this.getSide().getFacing().func_176734_d());
            IStorageMonitorable monitorable = accessor.getInventory((BaseActionSource)this.mySrc);
            if (monitorable != null) {
                monitorable.getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, (Object)this);
            }
            return monitorable;
        }
        return null;
    }
}

