/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractPartTerminal;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.part.IPartHasCustomModels;
import com.thiakil.appliedfluidics.util.FluidGuiBridge;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PartFluidTerminal
extends AbstractPartTerminal
implements IPartHasCustomModels {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedfluidics", "parts/fluid_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedfluidics", "parts/fluid_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});

    public PartFluidTerminal(ItemStack is) {
        super(is);
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!this.onPartActivate_wrench(player, hand, pos) && !player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            FluidGuiBridge.openGUI(player, this.getHost().getTile(), this.getSide(), FluidGuiBridge.ME_MONITORABLE);
            return true;
        }
        return false;
    }

    private boolean onPartActivate_wrench(EntityPlayer player, EnumHand hand, Vec3d pos) {
        TileEntity te = this.getTile();
        if (!player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)player.func_184586_b(hand), (BlockPos)te.func_174877_v(), (EnumHand)hand, (EnumFacing)this.getSide().getFacing(), (Vec3d)pos)) {
            if (Platform.isServer()) {
                return super.onPartActivate(player, hand, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation[] getModelsToRegister() {
        return new ResourceLocation[]{MODEL_OFF, MODEL_ON};
    }
}

