/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.ModSettings;
import com.thiakil.appliedfluidics.helpers.IFluidConfig;
import com.thiakil.appliedfluidics.part.PartFluidUpgradeable;
import com.thiakil.appliedfluidics.util.FluidConfigInventory;
import com.thiakil.appliedfluidics.util.FluidGuiBridge;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class PartSharedFluidBus
extends PartFluidUpgradeable
implements IGridTickable,
IFluidConfig {
    private final FluidConfigInventory config = new FluidConfigInventory((IAEAppEngInventory)this, 9);
    private boolean lastRedstone = false;

    public PartSharedFluidBus(ItemStack is) {
        super(is);
    }

    public void upgradesChanged() {
        this.updateState();
    }

    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.getConfig().readFromNBT(extra, "config");
    }

    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.getConfig().writeToNBT(extra, "config");
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.getConfig();
        }
        return super.getInventoryByName(name);
    }

    public void onNeighborChanged() {
        this.updateState();
        if (this.lastRedstone != this.getHost().hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    private TileEntity getTileEntity(TileEntity self, BlockPos pos) {
        World w = self.func_145831_w();
        if (w.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null) {
            return w.func_175625_s(pos);
        }
        return null;
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.getConfig().func_70302_i_());
    }

    protected int calculateFluidToSend() throws GridAccessException {
        int upgrades = this.getInstalledUpgrades(Upgrades.SPEED);
        int millibuckets = ModSettings.baseFluidImportExport;
        for (int i = 0; i < upgrades; ++i) {
            millibuckets *= 4;
        }
        millibuckets = (int)Math.min((double)millibuckets, 0.01 + this.getProxy().getEnergy().extractAEPower((double)millibuckets, Actionable.SIMULATE, PowerMultiplier.CONFIG));
        return millibuckets;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ImportBus.getMin(), TickRates.ImportBus.getMax(), this.getFluidHandler() == null, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    protected boolean canDoBusWork() {
        TileEntity self = this.getHost().getTile();
        BlockPos selfPos = self.func_174877_v().func_177972_a(this.getSide().getFacing());
        int xCoordinate = selfPos.func_177958_n();
        int zCoordinate = selfPos.func_177952_p();
        World world = self.func_145831_w();
        return world != null && world.func_72863_F().func_186026_b(xCoordinate >> 4, zCoordinate >> 4) != null;
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected boolean isSleeping() {
        return this.getFluidHandler() == null || super.isSleeping();
    }

    protected abstract TickRateModulation doBusWork();

    protected FluidConfigInventory getConfig() {
        return this.config;
    }

    @Override
    public FluidConfigInventory getFluidConfig() {
        return this.config;
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            FluidGuiBridge.openGUI(player, this.getHost().getTile(), this.getSide(), FluidGuiBridge.FLUID_BUS);
            return true;
        }
        return false;
    }
}

