/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.part;

import appeng.api.parts.IPartModel;
import appeng.parts.PartModel;
import appeng.parts.automation.PlaneConnections;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

class PlaneModels {
    public static final ResourceLocation MODEL_CHASSIS_OFF = new ResourceLocation("appliedfluidics", "parts/fluid_transition_plane_off");
    public static final ResourceLocation MODEL_CHASSIS_ON = new ResourceLocation("appliedfluidics", "parts/fluid_transition_plane_on");
    public static final ResourceLocation MODEL_CHASSIS_HAS_CHANNEL = new ResourceLocation("appliedfluidics", "parts/fluid_transition_plane_has_channel");
    private final Map<PlaneConnections, IPartModel> modelsOff;
    private final Map<PlaneConnections, IPartModel> modelsOn;
    private final Map<PlaneConnections, IPartModel> modelsHasChannel;

    public PlaneModels(String prefixOff, String prefixOn) {
        HashMap<PlaneConnections, PartModel> modelsOff = new HashMap<PlaneConnections, PartModel>();
        HashMap<PlaneConnections, PartModel> modelsOn = new HashMap<PlaneConnections, PartModel>();
        HashMap<PlaneConnections, PartModel> modelsHasChannel = new HashMap<PlaneConnections, PartModel>();
        for (PlaneConnections permutation : PlaneConnections.PERMUTATIONS) {
            ResourceLocation planeOff = new ResourceLocation("appliedfluidics", prefixOff + permutation.getFilenameSuffix());
            ResourceLocation planeOn = new ResourceLocation("appliedfluidics", prefixOn + permutation.getFilenameSuffix());
            modelsOff.put(permutation, new PartModel(new ResourceLocation[]{MODEL_CHASSIS_OFF, planeOff}));
            modelsOn.put(permutation, new PartModel(new ResourceLocation[]{MODEL_CHASSIS_ON, planeOff}));
            modelsHasChannel.put(permutation, new PartModel(new ResourceLocation[]{MODEL_CHASSIS_HAS_CHANNEL, planeOn}));
        }
        this.modelsOff = ImmutableMap.copyOf(modelsOff);
        this.modelsOn = ImmutableMap.copyOf(modelsOn);
        this.modelsHasChannel = ImmutableMap.copyOf(modelsHasChannel);
    }

    public IPartModel getModel(PlaneConnections connections, boolean hasPower, boolean hasChannel) {
        if (hasPower && hasChannel) {
            return this.modelsHasChannel.get(connections);
        }
        if (hasPower) {
            return this.modelsOn.get(connections);
        }
        return this.modelsOff.get(connections);
    }

    public List<IPartModel> getModels() {
        ArrayList<IPartModel> result = new ArrayList<IPartModel>();
        this.modelsOff.values().forEach(result::add);
        this.modelsOn.values().forEach(result::add);
        this.modelsHasChannel.values().forEach(result::add);
        return result;
    }
}

