/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.tile;

import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.block.BlockCertusTank;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileCertusTank
extends TileEntity
implements IFluidHandler,
IFluidTankProperties {
    private FluidStack containedFluid;
    public static int CAPACITY = 16000;
    private IBlockState state;
    private static byte PACKET_METADATA = (byte)127;

    public void onBlockActivated(World w, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        FluidActionResult res;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)heldItem);
        if (fluidHandler == null) {
            return;
        }
        FluidStack fs = fluidHandler.drain(Integer.MAX_VALUE, false);
        if (fs == null) {
            if (this.getContainedAmount() > 0) {
                Fluid myFluid = this.containedFluid.getFluid();
                FluidActionResult res2 = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)this, (IItemHandler)((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (int)CAPACITY, (EntityPlayer)player);
                if (res2.isSuccess()) {
                    player.func_184611_a(hand, res2.getResult());
                    FluidPlatform.playFluidSoundToUser((EntityPlayerMP)player, myFluid, true);
                }
            }
        } else if (this.canFillFluidType(fs) && (res = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)this, (IItemHandler)((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (int)CAPACITY, (EntityPlayer)player)).isSuccess()) {
            player.func_184611_a(hand, res.getResult());
            FluidPlatform.playFluidSoundToUser((EntityPlayerMP)player, fs.getFluid(), false);
        }
    }

    public void placed(ItemStack sourceItem) {
        NBTTagCompound fluidTag = sourceItem.func_179543_a("Fluid");
        if (sourceItem.func_77973_b() == BlockCertusTank.myItemblock && fluidTag != null) {
            this.containedFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        }
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        if (this.field_145850_b == null) {
            this.field_145850_b = worldIn;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("fluid")) {
            this.containedFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid"));
            if (this.containedFluid != null) {
                if (this.containedFluid.amount > CAPACITY) {
                    FluidicsMod.logger.debug("Reducing amount stored to max ({} > {})", (Object)this.containedFluid.amount, (Object)CAPACITY);
                    this.containedFluid.amount = CAPACITY;
                }
                this.setBlockBrightness();
            }
        } else {
            this.containedFluid = null;
            this.setBlockBrightness();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.containedFluid != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.containedFluid.writeToNBT(fluidTag);
            compound.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        return compound;
    }

    protected void setBlockBrightness() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    protected void forceClientUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_70296_d();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, (int)PACKET_METADATA, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == PACKET_METADATA) {
            this.handleUpdateTag(pkt.func_148857_g());
        }
    }

    @ParametersAreNonnullByDefault
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        assert (capability != null);
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @ParametersAreNonnullByDefault
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        assert (capability != null);
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFillFluidType(resource) || this.getContainedAmount() == CAPACITY || resource.amount <= 0) {
            return 0;
        }
        int fillAmount = Math.min(CAPACITY, this.getContainedAmount() + resource.amount) - this.getContainedAmount();
        if (doFill && fillAmount > 0) {
            if (this.containedFluid == null) {
                this.containedFluid = new FluidStack(resource.getFluid(), fillAmount);
                this.setBlockBrightness();
            } else {
                this.containedFluid.amount += fillAmount;
            }
            this.forceClientUpdate();
        }
        return fillAmount;
    }

    public int getContainedAmount() {
        if (this.containedFluid == null) {
            return 0;
        }
        return this.containedFluid.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.getContainedAmount() == 0 || !this.containedFluid.isFluidEqual(resource) || resource.amount <= 0) {
            return null;
        }
        int drainAmount = Math.min(this.containedFluid.amount, resource.amount);
        if (doDrain) {
            this.containedFluid.amount -= drainAmount;
            if (this.containedFluid.amount == 0) {
                this.containedFluid = null;
                this.setBlockBrightness();
            }
            this.forceClientUpdate();
        }
        return new FluidStack(resource.getFluid(), drainAmount);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getContainedAmount() == 0 || maxDrain <= 0) {
            return null;
        }
        return this.drain(new FluidStack(this.containedFluid.getFluid(), maxDrain), doDrain);
    }

    @Nullable
    public FluidStack getContents() {
        return this.containedFluid != null ? this.containedFluid.copy() : null;
    }

    public int getCapacity() {
        return CAPACITY;
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.containedFluid == null || this.containedFluid.isFluidEqual(fluidStack);
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.containedFluid != null && this.containedFluid.isFluidEqual(fluidStack);
    }
}

