/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import com.thiakil.appliedfluidics.util.ColourHelper;

public class CIELabHelper {
    private static final float DELTA = 0.20689656f;
    private static final float DELTA2 = 0.042806186f;
    private static final float DELTA3 = 0.008856452f;
    private static final float xr = 0.964221f;
    private static final float yr = 1.0f;
    private static final float zr = 0.825211f;
    private static final double EPS = 0.06475065;

    public static int changeColor(int inputColor, int targetColor) {
        float[] a = CIELabHelper.rgb2lab(inputColor, new float[3]);
        float[] b = CIELabHelper.rgb2lab(targetColor, new float[3]);
        float[] rgb = new float[3];
        CIELabHelper.lab2rgb((a[0] + 3.0f * b[0]) / 4.0f, b[1], b[2], rgb);
        return ColourHelper.colorClamp(rgb[0], rgb[1], rgb[2], ColourHelper.getAF(inputColor));
    }

    public static float[] lab2rgb(float l, float la, float lb, float[] rgb) {
        float Ls = (l - 0.5f) / 2.55f;
        float as = la - 0.5f;
        float bs = lb - 0.5f;
        float fy = (Ls + 16.0f) / 116.0f;
        float fx = fy + as / 500.0f;
        float fz = fy - bs / 200.0f;
        float xr = CIELabHelper.applyFInv(fx);
        float yr = CIELabHelper.applyFInv(fy);
        float zr = CIELabHelper.applyFInv(fz);
        float X = xr * 0.964221f;
        float Y = yr * 1.0f;
        float Z = zr * 0.825211f;
        float r = CIELabHelper.clamp(3.1340513f * X - 1.6170278f * Y - 0.4906522f * Z);
        float g = CIELabHelper.clamp(-0.97876275f * X + 1.9161422f * Y + 0.03344963f * Z);
        float b = CIELabHelper.clamp(0.07194258f * X - 0.2289712f * Y + 1.4052184f * Z);
        rgb[0] = CIELabHelper.applyGInv(r);
        rgb[1] = CIELabHelper.applyGInv(g);
        rgb[2] = CIELabHelper.applyGInv(b);
        return rgb;
    }

    public static float clamp(float x) {
        return x < 0.0f ? 0.0f : (x > 1.0f ? 1.0f : x);
    }

    public static float[] rgb2lab(int col, float[] lab) {
        return CIELabHelper.rgb2lab(ColourHelper.getRF(col), ColourHelper.getGF(col), ColourHelper.getBF(col), lab);
    }

    public static float[] rgb2lab(float r, float g, float b, float[] lab) {
        r = CIELabHelper.applyG(r);
        g = CIELabHelper.applyG(g);
        b = CIELabHelper.applyG(b);
        float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
        float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
        float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
        float xr = X / 0.964221f;
        float yr = Y / 1.0f;
        float zr = Z / 0.825211f;
        float fx = CIELabHelper.applyF(xr);
        float fy = CIELabHelper.applyF(yr);
        float fz = CIELabHelper.applyF(zr);
        float Ls = 116.0f * fy - 16.0f;
        float as = 500.0f * (fx - fy);
        float bs = 200.0f * (fy - fz);
        lab[0] = 2.55f * Ls + 0.5f;
        lab[1] = as + 0.5f;
        lab[2] = bs + 0.5f;
        return lab;
    }

    private static float applyG(float t) {
        return (double)t <= 0.06475065 ? t / 12.0f : (float)Math.pow(((double)t + 0.055) / 1.055, 2.4);
    }

    private static float applyGInv(float t) {
        return (double)t <= 0.005395887500000001 ? t * 12.0f : (float)(Math.pow(t, 0.4166666666666667) * 1.055 - 0.055);
    }

    private static float applyF(float xr) {
        float x = xr > 0.008856452f ? (float)Math.pow(xr, 0.3333333333333333) : xr / 0.12841856f + 0.13793103f;
        return x;
    }

    private static float applyFInv(float x) {
        float xr = x > 0.20689656f ? (float)Math.pow(x, 3.0) : 0.12841856f * (x - 0.13793103f);
        return xr;
    }

    public static float[] lab2rgb(float[] labf, float[] rgb) {
        return CIELabHelper.lab2rgb(labf[0], labf[1], labf[2], rgb);
    }
}

