/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import net.minecraft.util.math.MathHelper;

public class ColourHelper {
    public static int getA(int col) {
        return (col & 0xFF000000) >>> 24;
    }

    public static int getR(int col) {
        return (col & 0xFF0000) >> 16;
    }

    public static int getG(int col) {
        return (col & 0xFF00) >> 8;
    }

    public static int getB(int col) {
        return col & 0xFF;
    }

    public static float getRF(int col) {
        return (float)ColourHelper.getR(col) / 255.0f;
    }

    public static float getGF(int col) {
        return (float)ColourHelper.getG(col) / 255.0f;
    }

    public static float getBF(int col) {
        return (float)ColourHelper.getB(col) / 255.0f;
    }

    public static float getAF(int col) {
        return (float)ColourHelper.getA(col) / 255.0f;
    }

    public static int makeAlphaWhite(int alpha) {
        return alpha <= 0 ? 0 : (alpha >= 255 ? -1 : (alpha & 0xFF) << 24 | 0xFFFFFF);
    }

    public static int color(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static float[] colToFloat(int rgb) {
        return new float[]{(float)ColourHelper.getA(rgb) / 255.0f, (float)ColourHelper.getR(rgb) / 255.0f, (float)ColourHelper.getG(rgb) / 255.0f, (float)ColourHelper.getB(rgb) / 255.0f};
    }

    public static int floatsToCol(float[] rgb) {
        return ColourHelper.color((int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f), (int)(rgb[3] * 255.0f), (int)(rgb[0] * 255.0f));
    }

    public static int brightness(int col) {
        return ColourHelper.brightness(ColourHelper.getR(col), ColourHelper.getG(col), ColourHelper.getB(col));
    }

    public static int brightness(int r, int g, int b) {
        return r * 109 + g * 366 + b * 37 >> 9;
    }

    public static int makeGray(int b) {
        return ColourHelper.color(b, b, b, 255);
    }

    public static int colorClamp(float r, float g, float b, float a) {
        return ColourHelper.color(ColourHelper.clamp(r), ColourHelper.clamp(g), ColourHelper.clamp(b), ColourHelper.clamp(a));
    }

    public static int clamp(float f) {
        return MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
    }

    public static int multShade(int input, float perc) {
        return perc < 1.0f && input != 0 ? (perc <= 0.0f ? input & 0xFF000000 : ColourHelper.color(Math.round((float)ColourHelper.getR(input) * perc), Math.round((float)ColourHelper.getG(input) * perc), Math.round((float)ColourHelper.getB(input) * perc), ColourHelper.getA(input))) : input;
    }

    public static int alpha(int color, float alpha) {
        if (alpha == 0.0f) {
            return 0;
        }
        float af = ColourHelper.getAF(color);
        return af == 0.0f ? 0 : ColourHelper.colorClamp(ColourHelper.getRF(color), ColourHelper.getGF(color), ColourHelper.getBF(color), af * alpha);
    }
}

