/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.util.CIELabHelper;
import com.thiakil.appliedfluidics.util.ColourHelper;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidColours {
    private static TextureMap textureMapBlocks;
    private static HashMap<Fluid, Integer> COLOR_MAP;

    public static void init() {
        textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        COLOR_MAP = new HashMap();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            COLOR_MAP.put(fluid, FluidColours.getColourFromFluid(fluid));
        }
    }

    private static int getColourFromFluid(Fluid fluid) {
        String fluidName = fluid.getName();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            FluidicsMod.logger.debug("stillSprite == null {}", (Object)fluidName);
            return -1;
        }
        if (fluidStillSprite.func_110970_k() == 0) {
            FluidicsMod.logger.debug("framecount == 0 {}", (Object)fluidName);
            return -1;
        }
        int[][] pixels = fluidStillSprite.func_147965_a(0);
        int pr = 0;
        int pg = 0;
        int pb = 0;
        int pn = 0;
        int[][] nArray = pixels;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] pixel;
            for (int i2 : pixel = nArray[i]) {
                if (ColourHelper.getA(i2) < 16) continue;
                float[] lab = CIELabHelper.rgb2lab(i2, new float[3]);
                ++pn;
                pr = (int)((float)pr + lab[0]);
                pg = (int)((float)pg + lab[1]);
                pb = (int)((float)pb + lab[2]);
            }
        }
        if (pn == 0) {
            FluidicsMod.logger.debug("pn == 0 {}", (Object)fluidName);
            return -1;
        }
        float[] var19 = CIELabHelper.lab2rgb(pr / pn, pg / pn, pb / pn, new float[3]);
        return ColourHelper.colorClamp(var19[0], var19[1], var19[2], 1.0f);
    }

    public static int getColor(FluidStack stack) {
        Fluid fluid;
        if (stack != null && (fluid = stack.getFluid()) != null) {
            int base_color;
            int color = fluid.getColor(stack);
            try {
                base_color = COLOR_MAP.get(fluid);
            }
            catch (Exception e) {
                COLOR_MAP.put(fluid, -1);
                base_color = -1;
                FluidicsMod.logger.debug("Could not get colour for Fluid {}", (Object)fluid.getName());
            }
            if (color == -1) {
                return base_color;
            }
            float r = ColourHelper.getRF(color) * ColourHelper.getRF(base_color);
            float g = ColourHelper.getGF(color) * ColourHelper.getGF(base_color);
            float b = ColourHelper.getBF(color) * ColourHelper.getBF(base_color);
            return ColourHelper.colorClamp(r, g, b, 1.0f);
        }
        return -1;
    }

    static {
        COLOR_MAP = new HashMap();
    }
}

