/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageHelper;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.FluidList;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.item.ItemFluidDrop;
import com.thiakil.appliedfluidics.util.FluidPlatform;
import com.thiakil.appliedfluidics.util.NBTAwareAEFluidStack;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidDropWrapper
implements IMEInventoryHandler<IAEItemStack>,
ICraftingProvider,
ICraftingWatcherHost {
    protected IMEInventoryHandler<IAEFluidStack> parent;
    protected boolean isStealthy = false;
    protected final IEnergySource energy;
    protected ICraftingWatcher craftingWatcher;
    protected IItemList<IAEItemStack> pendingRequests;
    protected BaseActionSource mySrc = new BaseActionSource(){};
    private static IStorageHelper aeStorage = AEApi.instance().storage();

    public FluidDropWrapper(@Nonnull IMEInventoryHandler<IAEFluidStack> parent, IEnergySource energy) {
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        this.parent = parent;
        this.energy = energy;
    }

    public FluidDropWrapper(@Nonnull IMEInventoryHandler<IAEFluidStack> parent, IEnergySource energy, boolean stealthy) {
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        this.parent = parent;
        this.isStealthy = stealthy;
        this.energy = energy;
    }

    public AccessRestriction getAccess() {
        return this.parent.getAccess();
    }

    public boolean isPrioritized(IAEItemStack input) {
        if (this.isStealthy) {
            return false;
        }
        if (input.getItem() != ItemFluidDrop.INSTANCE) {
            return false;
        }
        FluidStack fs = ItemFluidDrop.getFluidStackFromStack(input.getItemStack());
        return fs != null && this.parent.isPrioritized((IAEStack)new NBTAwareAEFluidStack(fs));
    }

    public boolean canAccept(IAEItemStack input) {
        if (this.isStealthy) {
            return false;
        }
        FluidStack inputFS = ItemFluidDrop.getFluidStackFromStack(input.getItemStack());
        return inputFS != null && input.getItem() == ItemFluidDrop.INSTANCE && this.parent.canAccept((IAEStack)new NBTAwareAEFluidStack(inputFS).setStackSize(input.getStackSize() * (long)inputFS.amount));
    }

    public int getPriority() {
        return 0x7FFFFFFE;
    }

    public int getSlot() {
        return this.parent.getSlot();
    }

    public boolean validForPass(int i) {
        return this.parent.validForPass(i);
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        return this.injectItems(input, type, src, !this.isStealthy);
    }

    private IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src, boolean accept) {
        IAEFluidStack reject;
        if (!accept) {
            return input;
        }
        if (input.getItem() != ItemFluidDrop.INSTANCE || input.getStackSize() < 1L) {
            return input;
        }
        FluidStack inputFS = ItemFluidDrop.getFluidStackFromStack(input.getItemStack());
        if (inputFS == null) {
            return input;
        }
        NBTAwareAEFluidStack offer = new NBTAwareAEFluidStack(inputFS.copy());
        long offerAmount = (long)inputFS.amount * input.getStackSize();
        if (this.energy != null) {
            offerAmount = FluidPlatform.capAmountByPowerAvailable(offerAmount, this.energy);
        }
        offer.setStackSize(offerAmount);
        do {
            if ((reject = (IAEFluidStack)this.parent.injectItems((IAEStack)offer, Actionable.SIMULATE, src)) == null || reject.getStackSize() <= 0L) continue;
            offerAmount = offer.getStackSize() - (long)inputFS.amount;
            if (this.energy != null) {
                offerAmount = FluidPlatform.capAmountByPowerAvailable(offerAmount, this.energy);
            }
            if (offerAmount % (long)inputFS.amount != 0L) {
                offerAmount -= offerAmount % (long)inputFS.amount;
            }
            offer.setStackSize(offerAmount);
        } while (reject != null && reject.getStackSize() > 0L && offer.getStackSize() > 0L);
        if (offer.getStackSize() <= 0L) {
            return input;
        }
        reject = type == Actionable.SIMULATE || this.energy == null ? (IAEFluidStack)this.parent.injectItems((IAEStack)offer, type, src) : FluidPlatform.poweredInsert(this.energy, this.parent, offer, src);
        long ableToInsert = offer.getStackSize() / (long)inputFS.amount;
        IAEItemStack rejectItems = input.copy();
        rejectItems.setStackSize(input.getStackSize() - ableToInsert);
        if (reject != null && reject.getStackSize() > 0L) {
            FluidicsMod.logger.error("Fluid handler rejected " + reject.getStackSize() + "mb, after it told us it could accept it. ItemDrop stack has " + inputFS.amount + "mb per each.");
        }
        return rejectItems.getStackSize() > 0L ? rejectItems : null;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (this.isStealthy && src != this.mySrc) {
            return null;
        }
        if (request.getItem() != ItemFluidDrop.INSTANCE) {
            return null;
        }
        request.setStackSize(Math.min(request.getStackSize(), Integer.MAX_VALUE));
        FluidStack outputFS = ItemFluidDrop.getFluidStackFromStack(request.getItemStack());
        if (outputFS == null) {
            return null;
        }
        outputFS.amount = Math.max(outputFS.amount, 1000);
        int requestAmount = (int)Math.min((long)outputFS.amount * Math.max(request.getStackSize(), 1L), 2147483000L);
        IAEFluidStack fluidRequest = new NBTAwareAEFluidStack(outputFS).setStackSize(requestAmount);
        IAEFluidStack canExtract = (IAEFluidStack)this.parent.extractItems((IAEStack)fluidRequest, Actionable.SIMULATE, src);
        if (canExtract == null || canExtract.getStackSize() < (long)outputFS.amount) {
            return null;
        }
        if (this.energy != null) {
            canExtract.setStackSize(FluidPlatform.capAmountByPowerAvailable(canExtract.getStackSize(), this.energy));
        }
        if (canExtract.getStackSize() < fluidRequest.getStackSize()) {
            fluidRequest.setStackSize(canExtract.getStackSize() - canExtract.getStackSize() % (long)outputFS.amount);
        }
        if (canExtract.getStackSize() <= 0L) {
            return null;
        }
        IAEFluidStack extracted = mode == Actionable.SIMULATE || this.energy == null ? (IAEFluidStack)this.parent.extractItems((IAEStack)fluidRequest, mode, src) : FluidPlatform.poweredExtraction(this.energy, this.parent, fluidRequest, src);
        if (extracted == null) {
            return null;
        }
        ItemStack outputStack = ItemFluidDrop.newDropDrainFluidStack(outputFS.copy());
        if (outputStack.func_190926_b()) {
            return null;
        }
        outputStack.func_190920_e((int)extracted.getStackSize() / outputFS.amount);
        return aeStorage.createItemStack(outputStack);
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        IItemList fluids = this.parent.getAvailableItems((IItemList)new FluidList());
        for (IAEFluidStack fluid : fluids) {
            ItemStack drop;
            if (fluid.getStackSize() + fluid.getCountRequestable() < 1000L || (drop = ItemFluidDrop.getFilledDrop(((IAEFluidStack)fluid.copy().setStackSize(1000L)).getFluidStack())).func_190926_b()) continue;
            if (this.isStealthy) {
                out.addRequestable(((IAEItemStack)aeStorage.createItemStack(drop).setStackSize(0L)).setCountRequestable((fluid.getStackSize() + fluid.getCountRequestable()) / 1000L));
                continue;
            }
            out.add(aeStorage.createItemStack(drop).setStackSize((fluid.getStackSize() + fluid.getCountRequestable()) / 1000L));
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IItemList<IAEItemStack> available = this.getAvailableItems((IItemList<IAEItemStack>)StorageChannel.ITEMS.createList());
        for (IAEItemStack stack : available) {
            craftingTracker.setEmitable(stack);
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return false;
    }

    public boolean isBusy() {
        return true;
    }

    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.craftingWatcher = newWatcher;
        this.pendingRequests = AEApi.instance().storage().createItemList();
        ArrayList<ItemStack> fluidDrops = new ArrayList<ItemStack>();
        ItemFluidDrop.getAllDrops(fluidDrops);
        for (ItemStack stack : fluidDrops) {
            this.craftingWatcher.add((IAEStack)AEApi.instance().storage().createItemStack(stack));
        }
    }

    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        FluidicsMod.logger.debug("crafting status change: {}x{}", (Object)what.getItem().getRegistryName(), (Object)what.getStackSize());
        this.pendingRequests.add((IAEStack)what);
    }

    public void processPendingRequests(IMEInventoryHandler<IAEItemStack> destination) {
        if (!this.pendingRequests.isEmpty()) {
            Iterator pendingIterator = this.pendingRequests.iterator();
            while (pendingIterator.hasNext()) {
                IAEItemStack wanted = (IAEItemStack)pendingIterator.next();
                IAEItemStack got = this.extractItems(wanted, Actionable.MODULATE, this.mySrc);
                if (got == null || got.getStackSize() <= 0L) continue;
                IAEItemStack rejects = (IAEItemStack)destination.injectItems((IAEStack)got, Actionable.MODULATE, this.mySrc);
                if (rejects == null || rejects.getStackSize() == 0L) {
                    wanted.decStackSize(got.getStackSize());
                } else {
                    wanted.decStackSize(got.getStackSize() - rejects.getStackSize());
                    this.injectItems(rejects, Actionable.MODULATE, this.mySrc, true);
                }
                if (wanted.getStackSize() != 0L) continue;
                pendingIterator.remove();
            }
        }
    }
}

