/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.definitions.IMaterials;
import appeng.api.exceptions.AppEngException;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.GuiNull;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.ContainerOpenContext;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.util.Platform;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.container.ContainerAdvancedInterfaceTerminal;
import com.thiakil.appliedfluidics.container.ContainerFluidBus;
import com.thiakil.appliedfluidics.container.ContainerFluidFormationPlane;
import com.thiakil.appliedfluidics.container.ContainerFluidInterface;
import com.thiakil.appliedfluidics.container.ContainerFluidLevelEmitter;
import com.thiakil.appliedfluidics.container.ContainerFluidStorageBus;
import com.thiakil.appliedfluidics.container.ContainerMEMonitorableFluid;
import com.thiakil.appliedfluidics.container.ContainerPriorityAF;
import com.thiakil.appliedfluidics.part.PartAdvancedInterfaceTerminal;
import com.thiakil.appliedfluidics.part.PartFluidFormationPlane;
import com.thiakil.appliedfluidics.part.PartFluidLevelEmitter;
import com.thiakil.appliedfluidics.part.PartFluidStorage;
import com.thiakil.appliedfluidics.part.PartSharedFluidBus;
import com.thiakil.appliedfluidics.util.GuiHostType;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public enum FluidGuiBridge implements IGuiHandler
{
    GUI_Handler,
    FLUID_BUS(ContainerFluidBus.class, PartSharedFluidBus.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    FLUID_STORAGE_BUS(ContainerFluidStorageBus.class, PartFluidStorage.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    FLUID_FORMATION_PLANE(ContainerFluidFormationPlane.class, PartFluidFormationPlane.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    ME_MONITORABLE(ContainerMEMonitorableFluid.class, ITerminalHost.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    LEVEL_EMITTER(ContainerFluidLevelEmitter.class, PartFluidLevelEmitter.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    PRIORITY(ContainerPriorityAF.class, IPriorityHost.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    INTERFACE(ContainerFluidInterface.class, IInterfaceHost.class, GuiHostType.WORLD, SecurityPermissions.BUILD),
    INTERFACE_TERMINAL(ContainerAdvancedInterfaceTerminal.class, PartAdvancedInterfaceTerminal.class, GuiHostType.WORLD, SecurityPermissions.BUILD);

    private final Class tileClass;
    private final Class containerClass;
    private Class guiClass;
    private GuiHostType type;
    private SecurityPermissions requiredPermission;

    private FluidGuiBridge() {
        this.tileClass = null;
        this.guiClass = null;
        this.containerClass = null;
    }

    private FluidGuiBridge(Class containerClass, SecurityPermissions requiredPermission) {
        this.requiredPermission = requiredPermission;
        this.containerClass = containerClass;
        this.tileClass = null;
        this.getGui();
    }

    private void getGui() {
        if (Platform.isClient()) {
            AEBaseGui.class.getName();
            String start = this.containerClass.getName();
            String guiClass = start.replaceFirst("container.", "client.gui.").replace(".Container", ".Gui");
            if (start.equals(guiClass)) {
                throw new IllegalStateException("Unable to find gui class");
            }
            this.guiClass = ReflectionHelper.getClass((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String[])new String[]{guiClass});
            if (this.guiClass == null) {
                throw new IllegalStateException("Cannot Load class: " + guiClass);
            }
        }
    }

    private FluidGuiBridge(Class containerClass, Class tileClass, GuiHostType type, SecurityPermissions requiredPermission) {
        this.requiredPermission = requiredPermission;
        this.containerClass = containerClass;
        this.type = type;
        this.tileClass = tileClass;
        this.getGui();
    }

    public Object getServerGuiElement(int ordinal, EntityPlayer player, World w, int x, int y, int z) {
        boolean stem;
        AEPartLocation side = AEPartLocation.fromOrdinal((int)(ordinal & 7));
        FluidGuiBridge ID = FluidGuiBridge.values()[ordinal >> 4];
        boolean bl = stem = (ordinal >> 3 & 1) == 1;
        if (ID.type.isItem()) {
            ItemStack it = ItemStack.field_190927_a;
            if (stem) {
                it = player.field_71071_by.func_70448_g();
            } else if (x >= 0 && x < player.field_71071_by.field_70462_a.size()) {
                it = player.field_71071_by.func_70301_a(x);
            }
            Object myItem = this.getGuiObject(it, player, w, x, y, z);
            if (myItem != null && ID.CorrectTileOrPart(myItem)) {
                return this.updateGui(ID.ConstructContainer(player.field_71071_by, side, myItem), w, x, y, z, side, myItem);
            }
        }
        if (ID.type.isTile()) {
            TileEntity TE = w.func_175625_s(new BlockPos(x, y, z));
            if (TE instanceof IPartHost) {
                ((IPartHost)TE).getPart(side);
                IPart part = ((IPartHost)TE).getPart(side);
                if (ID.CorrectTileOrPart(part)) {
                    return this.updateGui(ID.ConstructContainer(player.field_71071_by, side, part), w, x, y, z, side, part);
                }
            } else if (ID.CorrectTileOrPart(TE)) {
                return this.updateGui(ID.ConstructContainer(player.field_71071_by, side, TE), w, x, y, z, side, TE);
            }
        }
        return new ContainerNull();
    }

    private Object getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        if (!it.func_190926_b()) {
            if (it.func_77973_b() instanceof IGuiItem) {
                return ((IGuiItem)it.func_77973_b()).getGuiObject(it, w, new BlockPos(x, y, z));
            }
            IWirelessTermHandler iWirelessTermHandler = AEApi.instance().registries().wireless().getWirelessTerminalHandler(it);
        }
        return null;
    }

    public boolean CorrectTileOrPart(Object tE) {
        if (this.tileClass == null) {
            throw new IllegalArgumentException("This Gui Cannot use the standard Handler.");
        }
        return this.tileClass.isInstance(tE);
    }

    private Object updateGui(Object newContainer, World w, int x, int y, int z, AEPartLocation side, Object myItem) {
        if (newContainer instanceof AEBaseContainer) {
            AEBaseContainer bc = (AEBaseContainer)newContainer;
            bc.setOpenContext(new ContainerOpenContext(myItem));
            bc.getOpenContext().setWorld(w);
            bc.getOpenContext().setX(x);
            bc.getOpenContext().setY(y);
            bc.getOpenContext().setZ(z);
            bc.getOpenContext().setSide(side);
        }
        return newContainer;
    }

    public Object ConstructContainer(InventoryPlayer inventory, AEPartLocation side, Object tE) {
        try {
            Constructor[] c = this.containerClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            Object o = target.newInstance(inventory, tE);
            if (o instanceof AEBaseContainer) {
                AEBaseContainer bc = (AEBaseContainer)o;
                for (Object so : bc.field_75151_b) {
                    if (!(so instanceof Slot)) continue;
                    ItemStack is = ((Slot)so).func_75211_c();
                    IMaterials iMaterials = AEApi.instance().definitions().materials();
                }
            }
            return o;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private Constructor findConstructor(Constructor[] c, InventoryPlayer inventory, Object tE) {
        for (Constructor con : c) {
            Class<?>[] types = con.getParameterTypes();
            if (types.length != 2 || !types[0].isAssignableFrom(inventory.getClass()) || !types[1].isAssignableFrom(tE.getClass())) continue;
            return con;
        }
        return null;
    }

    private String typeName(Object inventory) {
        if (inventory == null) {
            return "NULL";
        }
        return inventory.getClass().getName();
    }

    public Object getClientGuiElement(int ordinal, EntityPlayer player, World w, int x, int y, int z) {
        boolean stem;
        AEPartLocation side = AEPartLocation.fromOrdinal((int)(ordinal & 7));
        FluidGuiBridge ID = FluidGuiBridge.values()[ordinal >> 4];
        boolean bl = stem = (ordinal >> 3 & 1) == 1;
        if (ID.type.isItem()) {
            ItemStack it = ItemStack.field_190927_a;
            if (stem) {
                it = player.field_71071_by.func_70448_g();
            } else if (x >= 0 && x < player.field_71071_by.field_70462_a.size()) {
                it = player.field_71071_by.func_70301_a(x);
            }
            Object myItem = this.getGuiObject(it, player, w, x, y, z);
            if (myItem != null && ID.CorrectTileOrPart(myItem)) {
                return ID.ConstructGui(player.field_71071_by, side, myItem);
            }
        }
        if (ID.type.isTile()) {
            TileEntity TE = w.func_175625_s(new BlockPos(x, y, z));
            if (TE instanceof IPartHost) {
                ((IPartHost)TE).getPart(side);
                IPart part = ((IPartHost)TE).getPart(side);
                if (ID.CorrectTileOrPart(part)) {
                    return ID.ConstructGui(player.field_71071_by, side, part);
                }
            } else if (ID.CorrectTileOrPart(TE)) {
                return ID.ConstructGui(player.field_71071_by, side, TE);
            }
        }
        return new GuiNull((Container)new ContainerNull());
    }

    public Object ConstructGui(InventoryPlayer inventory, AEPartLocation side, Object tE) {
        try {
            Constructor[] c = this.guiClass.getConstructors();
            if (c.length == 0) {
                throw new AppEngException("Invalid Gui Class");
            }
            Constructor target = this.findConstructor(c, inventory, tE);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + this.containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(tE) + " )");
            }
            return target.newInstance(inventory, tE);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public boolean hasPermissions(TileEntity te, int x, int y, int z, AEPartLocation side, EntityPlayer player) {
        World w = player.func_130014_f_();
        BlockPos pos = new BlockPos(x, y, z);
        if (Platform.hasPermissions((DimensionalCoord)(te != null ? new DimensionalCoord(te) : new DimensionalCoord(player.field_70170_p, pos)), (EntityPlayer)player)) {
            IGuiItemObject myItem;
            ItemStack it;
            if (this.type.isItem() && !(it = player.field_71071_by.func_70448_g()).func_190926_b() && it.func_77973_b() instanceof IGuiItem && this.CorrectTileOrPart(myItem = ((IGuiItem)it.func_77973_b()).getGuiObject(it, w, pos))) {
                return true;
            }
            if (this.type.isTile()) {
                TileEntity TE = w.func_175625_s(pos);
                if (TE instanceof IPartHost) {
                    ((IPartHost)TE).getPart(side);
                    IPart part = ((IPartHost)TE).getPart(side);
                    if (this.CorrectTileOrPart(part)) {
                        return this.securityCheck(part, player);
                    }
                } else if (this.CorrectTileOrPart(TE)) {
                    return this.securityCheck(TE, player);
                }
            }
        }
        return false;
    }

    private boolean securityCheck(Object te, EntityPlayer player) {
        if (te instanceof IActionHost && this.requiredPermission != null) {
            IGrid g;
            IGridNode gn = ((IActionHost)te).getActionableNode();
            if (gn != null && (g = gn.getGrid()) != null) {
                boolean requirePower = false;
                ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                if (sg.hasPermission(player, this.requiredPermission)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public GuiHostType getType() {
        return this.type;
    }

    public static void openGUI(@Nonnull EntityPlayer p, @Nullable TileEntity tile, @Nullable AEPartLocation side, @Nonnull FluidGuiBridge type) {
        if (Platform.isClient()) {
            return;
        }
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (tile != null) {
            x = tile.func_174877_v().func_177958_n();
            y = tile.func_174877_v().func_177956_o();
            z = tile.func_174877_v().func_177952_p();
        }
        if (type.getType().isItem() && tile == null || type.hasPermissions(tile, x, y, z, side, p)) {
            if (tile == null && type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)FluidicsMod.INSTANCE, type.ordinal() << 4, p.func_130014_f_(), p.field_71071_by.field_70461_c, 0, 0);
            } else if (tile == null || type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)FluidicsMod.INSTANCE, type.ordinal() << 4 | 8, p.func_130014_f_(), x, y, z);
            } else {
                p.openGui((Object)FluidicsMod.INSTANCE, type.ordinal() << 4 | side.ordinal(), tile.func_145831_w(), x, y, z);
            }
        }
    }
}

