/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.stats.Stats;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.ModSettings;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidPlatform {
    public static IAEFluidStack poweredExtraction(IEnergySource energy, IMEInventory<IAEFluidStack> cell, IAEFluidStack request, BaseActionSource src) {
        double availablePower;
        long itemToExtract;
        IAEFluidStack possible = (IAEFluidStack)cell.extractItems((IAEStack)request.copy(), Actionable.SIMULATE, src);
        long retrieved = 0L;
        if (possible != null) {
            retrieved = possible.getStackSize();
        }
        if ((itemToExtract = Math.min((long)((availablePower = energy.extractAEPower((double)retrieved * ModSettings.powerMultiplier, Actionable.SIMULATE, PowerMultiplier.ONE)) / ModSettings.powerMultiplier), retrieved)) > 0L) {
            FluidicsMod.logger.debug("Extracting power: {}", (Object)((double)retrieved * ModSettings.powerMultiplier));
            energy.extractAEPower((double)retrieved * ModSettings.powerMultiplier, Actionable.MODULATE, PowerMultiplier.ONE);
            possible.setStackSize(itemToExtract);
            IAEFluidStack ret = (IAEFluidStack)cell.extractItems((IAEStack)possible, Actionable.MODULATE, src);
            if (ret != null && src.isPlayer()) {
                Stats.ItemsExtracted.addToPlayer(((PlayerSource)src).player, (int)ret.getStackSize());
            }
            return ret;
        }
        return null;
    }

    public static IAEFluidStack poweredInsert(IEnergySource energy, IMEInventory<IAEFluidStack> cell, IAEFluidStack input, BaseActionSource src) {
        double availablePower;
        long itemToAdd;
        IAEFluidStack willReject = (IAEFluidStack)cell.injectItems((IAEStack)input.copy(), Actionable.SIMULATE, src);
        long stored = input.getStackSize();
        if (willReject != null) {
            stored -= willReject.getStackSize();
        }
        if ((itemToAdd = Math.min((long)((availablePower = energy.extractAEPower((double)stored * ModSettings.powerMultiplier, Actionable.SIMULATE, PowerMultiplier.ONE)) / ModSettings.powerMultiplier), stored)) < input.getStackSize()) {
            FluidicsMod.logger.debug("could not extract enough power?");
        }
        if (itemToAdd > 0L) {
            FluidicsMod.logger.debug("Extracting power: {}", (Object)((double)stored * ModSettings.powerMultiplier));
            energy.extractAEPower((double)stored * ModSettings.powerMultiplier, Actionable.MODULATE, PowerMultiplier.ONE);
            if (itemToAdd < input.getStackSize()) {
                long original = input.getStackSize();
                IAEFluidStack split = input.copy();
                split.decStackSize(itemToAdd);
                input.setStackSize(itemToAdd);
                split.add((IAEFluidStack)cell.injectItems((IAEStack)input, Actionable.MODULATE, src));
                if (src.isPlayer()) {
                    long diff = original - split.getStackSize();
                    Stats.ItemsInserted.addToPlayer(((PlayerSource)src).player, (int)diff);
                }
                return split;
            }
            IAEFluidStack ret = (IAEFluidStack)cell.injectItems((IAEStack)input, Actionable.MODULATE, src);
            if (src.isPlayer()) {
                long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                Stats.ItemsInserted.addToPlayer(((PlayerSource)src).player, (int)diff);
            }
            return ret;
        }
        return input;
    }

    public static long capAmountByPowerAvailable(long maxAmount, IEnergySource energy) {
        double availablePower = energy.extractAEPower((double)maxAmount * ModSettings.powerMultiplier, Actionable.SIMULATE, PowerMultiplier.ONE);
        return Math.min((long)(availablePower / ModSettings.powerMultiplier + 0.9), maxAmount);
    }

    public static long extractPowerForAmount(long amount, IEnergySource energy) {
        double availablePower = energy.extractAEPower((double)amount * ModSettings.powerMultiplier, Actionable.MODULATE, PowerMultiplier.ONE);
        return Math.min((long)(availablePower / ModSettings.powerMultiplier + 0.9), amount);
    }

    public static SoundEvent getFluidSound(Fluid fluid, boolean filled) {
        SoundEvent snd;
        SoundEvent soundEvent = snd = filled ? fluid.getFillSound() : fluid.getEmptySound();
        if (snd != null && SoundEvent.field_187505_a.func_148757_b((Object)snd) == 0) {
            FluidicsMod.logger.error("Fill sound is not registered, this is a bug in " + snd.func_187503_a().func_110624_b());
        }
        if (snd == null || SoundEvent.field_187505_a.func_148757_b((Object)snd) == 0) {
            snd = filled ? FluidRegistry.WATER.getFillSound() : FluidRegistry.WATER.getEmptySound();
        }
        return snd;
    }

    public static void playFluidSoundToUser(@Nonnull EntityPlayerMP player, Fluid fluid, boolean filled) {
        if (fluid == null) {
            fluid = FluidRegistry.WATER;
        }
        SoundEvent snd = FluidPlatform.getFluidSound(fluid, filled);
        BlockPos playerPos = player.func_180425_c();
        SPacketSoundEffect packetSoundEffect = new SPacketSoundEffect(snd, SoundCategory.BLOCKS, (double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p(), 1.0f, 1.0f);
        player.field_71135_a.func_147359_a((Packet)packetSoundEffect);
    }

    public static void playFluidSoundAt(World world, @Nonnull BlockPos pos, Fluid fluid, boolean filled) {
        if (fluid == null) {
            fluid = FluidRegistry.WATER;
        }
        SoundEvent snd = FluidPlatform.getFluidSound(fluid, filled);
        world.func_184133_a(null, pos, snd, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

