/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.text.WordUtils;

public class ModNames {
    private static final Map<String, String> modNamesForIds = new HashMap<String, String>();

    public static void init() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            modNamesForIds.put(lowercaseId, modName);
        }
    }

    public static String getModNameFromResource(ResourceLocation loc) {
        String modId = loc.func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = modNamesForIds.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static String getModNameFromFluid(Fluid fl) {
        return ModNames.getModNameFromResource(fl.getStill());
    }
}

