/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.util.item.AEFluidStack;
import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.util.FluidStackUtils;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class NBTAwareAEFluidStack
implements IAEFluidStack,
Comparable<NBTAwareAEFluidStack> {
    private FluidStack internalStack;
    private Fluid fluid;
    private long stackSize = 0L;
    private final int hashCode;
    private long countRequestable = 0L;
    private boolean isCraftable = false;

    public NBTAwareAEFluidStack(AEFluidStack aefs) {
        this(aefs.getFluidStack());
        this.stackSize = aefs.getStackSize();
    }

    public NBTAwareAEFluidStack(NBTAwareAEFluidStack fs) {
        this.internalStack = fs.internalStack.copy();
        this.fluid = fs.fluid;
        this.stackSize = fs.stackSize;
        this.isCraftable = fs.isCraftable;
        this.countRequestable = fs.countRequestable;
        this.hashCode = this.fluid.hashCode() ^ (this.internalStack.tag == null ? 0 : this.internalStack.tag.hashCode());
    }

    public NBTAwareAEFluidStack(FluidStack fs) {
        this.internalStack = fs.copy();
        this.fluid = this.internalStack.getFluid();
        this.stackSize = fs.amount;
        this.hashCode = this.fluid.hashCode() ^ (this.internalStack.tag == null ? 0 : this.internalStack.tag.hashCode());
    }

    public NBTAwareAEFluidStack(ItemStack is) {
        this(FluidUtil.getFluidContained((ItemStack)is));
    }

    public FluidStack getFluidStack() {
        FluidStack outstack = this.internalStack.copy();
        if (this.stackSize > Integer.MAX_VALUE) {
            FluidicsMod.logger.warn("Sending fluidstack, but actual amount > max_int!");
        }
        outstack.amount = (int)this.stackSize;
        return outstack;
    }

    public void add(IAEFluidStack option) {
        if (option == null) {
            return;
        }
        if (!this.internalStack.isFluidEqual(option.getFluidStack())) {
            try {
                FluidicsMod.logger.error("Tried to add IAEFluidStack that is NOT the same. This is a BAD THING. Refusing to add.");
                FluidicsMod.logger.error("I am " + this.toString());
                FluidicsMod.logger.error("It is " + option.getFluid().getName() + (option.getFluidStack().tag != null ? ", " + option.getFluidStack().toString() : ""));
            }
            catch (Throwable t) {
                FluidicsMod.logger.error("Error during debug output", t);
            }
            return;
        }
        this.stackSize += option.getStackSize();
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    public long getStackSize() {
        return this.stackSize;
    }

    public IAEFluidStack setStackSize(long stackSize) {
        this.stackSize = stackSize;
        return this;
    }

    public long getCountRequestable() {
        return this.countRequestable;
    }

    public IAEFluidStack setCountRequestable(long countRequestable) {
        this.countRequestable = countRequestable;
        return this;
    }

    public boolean isCraftable() {
        return this.isCraftable;
    }

    public IAEFluidStack setCraftable(boolean isCraftable) {
        this.isCraftable = isCraftable;
        return this;
    }

    public IAEFluidStack reset() {
        this.stackSize = 0L;
        this.setCountRequestable(0L);
        this.setCraftable(false);
        return this;
    }

    public boolean isMeaningful() {
        return this.stackSize != 0L || this.countRequestable > 0L || this.isCraftable;
    }

    public void incStackSize(long i) {
        this.stackSize += i;
    }

    public void decStackSize(long i) {
        this.stackSize -= i;
    }

    public void incCountRequestable(long i) {
        this.countRequestable += i;
    }

    public void decCountRequestable(long i) {
        this.countRequestable -= i;
    }

    public void writeToNBT(NBTTagCompound i) {
        i.func_74772_a("AF:stackSize", this.stackSize);
        i.func_74772_a("AF:requestable", this.countRequestable);
        i.func_74757_a("AF:craftable", this.isCraftable);
        this.internalStack.writeToNBT(i);
    }

    @Nullable
    public static NBTAwareAEFluidStack loadFromNBT(NBTTagCompound tag) {
        FluidStack loadedFS = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        if (loadedFS == null) {
            return null;
        }
        NBTAwareAEFluidStack newStack = new NBTAwareAEFluidStack(loadedFS);
        newStack.setStackSize(tag.func_74763_f("AF:stackSize"));
        newStack.setCountRequestable(tag.func_74763_f("AF:requestable"));
        newStack.setCraftable(tag.func_74767_n("AF:craftable"));
        return newStack;
    }

    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        if (st instanceof IAEFluidStack) {
            return this.fluid == ((IAEFluidStack)st).getFluid();
        }
        if (st instanceof FluidStack) {
            return this.fluid == ((FluidStack)st).getFluid();
        }
        return false;
    }

    public void writeToPacket(ByteBuf i) throws IOException {
        byte mask = (byte)(this.getType(0L) | this.getType(this.stackSize) << 2 | this.getType(this.countRequestable) << 4 | (byte)(this.isCraftable ? 1 : 0) << 6 | (this.internalStack.tag != null ? 1 : 0) << 7);
        i.writeByte((int)mask);
        this.writeIdentity(i);
        this.readNBT(i);
        this.putPacketValue(i, this.stackSize);
        this.putPacketValue(i, this.countRequestable);
    }

    public static IAEFluidStack loadFluidStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        byte len2 = data.readByte();
        byte[] name = new byte[len2];
        data.readBytes(name, 0, (int)len2);
        d.func_74778_a("FluidName", new String(name, "UTF-8"));
        d.func_74774_a("Amount", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(bd));
            d.func_74782_a("Tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)di));
        }
        long stackSize = NBTAwareAEFluidStack.getPacketValue(stackType, data);
        long countRequestable = NBTAwareAEFluidStack.getPacketValue(countReqType, data);
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)d);
        if (fluidStack == null) {
            return null;
        }
        NBTAwareAEFluidStack fluid = new NBTAwareAEFluidStack(fluidStack);
        fluid.setStackSize(stackSize);
        fluid.setCountRequestable(countRequestable);
        fluid.setCraftable(isCraftable);
        return fluid;
    }

    private byte getType(long num) {
        if (num <= 255L) {
            return 0;
        }
        if (num <= 65535L) {
            return 1;
        }
        if (num <= 0xFFFFFFFFL) {
            return 2;
        }
        return 3;
    }

    private void writeIdentity(ByteBuf i) throws IOException {
        byte[] name = this.fluid.getName().getBytes("UTF-8");
        i.writeByte((int)((byte)name.length));
        i.writeBytes(name);
    }

    private void readNBT(ByteBuf i) throws IOException {
        if (this.internalStack.tag != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.internalStack.tag, (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.writeBytes(tagBytes);
        }
    }

    private void putPacketValue(ByteBuf tag, long num) {
        if (num <= 255L) {
            tag.writeByte((int)((byte)(num + -128L)));
        } else if (num <= 65535L) {
            tag.writeShort((int)((short)(num + -32768L)));
        } else if (num <= 0xFFFFFFFFL) {
            tag.writeInt((int)(num + Integer.MIN_VALUE));
        } else {
            tag.writeLong(num);
        }
    }

    public IAEFluidStack copy() {
        return new NBTAwareAEFluidStack(this);
    }

    public IAEFluidStack empty() {
        return new NBTAwareAEFluidStack(this).reset();
    }

    public IAETagCompound getTagCompound() {
        return null;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return true;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public int compareTo(NBTAwareAEFluidStack o) {
        int diff = this.hashCode() - o.hashCode();
        return diff > 0 ? 1 : (diff < 0 ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof NBTAwareAEFluidStack) {
            return FluidStackUtils.arefluidsEqual(this.internalStack, ((NBTAwareAEFluidStack)obj).internalStack);
        }
        if (obj instanceof IAEFluidStack) {
            return FluidStackUtils.arefluidsEqual(this.internalStack, ((IAEFluidStack)obj).getFluidStack());
        }
        if (obj instanceof FluidStack) {
            return FluidStackUtils.arefluidsEqual(this.internalStack, (FluidStack)obj);
        }
        return false;
    }

    public String toString() {
        return this.stackSize + "mb x " + this.fluid.getName() + (this.internalStack.tag != null ? ", " + this.internalStack.tag.toString() : "");
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static long getPacketValue(byte type, ByteBuf tag) {
        if (type == 0) {
            long l = tag.readByte();
            return l -= -128L;
        }
        if (type == 1) {
            long l = tag.readShort();
            return l -= -32768L;
        }
        if (type == 2) {
            long l = tag.readInt();
            return l -= Integer.MIN_VALUE;
        }
        return tag.readLong();
    }
}

