/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util;

import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;

public final class ReadableNumberConverterBuckets
extends Enum<ReadableNumberConverterBuckets>
implements ISlimReadableNumberConverter,
IWideReadableNumberConverter {
    public static final /* enum */ ReadableNumberConverterBuckets INSTANCE = new ReadableNumberConverterBuckets();
    private static final int DIVISION_BASE = 1000;
    private static final char[] ENCODED_POSTFIXES;
    private final Format format;
    private static final /* synthetic */ ReadableNumberConverterBuckets[] $VALUES;

    public static ReadableNumberConverterBuckets[] values() {
        return (ReadableNumberConverterBuckets[])$VALUES.clone();
    }

    public static ReadableNumberConverterBuckets valueOf(String name) {
        return Enum.valueOf(ReadableNumberConverterBuckets.class, name);
    }

    private ReadableNumberConverterBuckets() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(".#;0.#");
        format.setDecimalFormatSymbols(symbols);
        format.setRoundingMode(RoundingMode.DOWN);
        this.format = format;
    }

    public String toSlimReadableForm(long number) {
        return this.toReadableFormRestrictedByWidth(number, 3);
    }

    private String toReadableFormRestrictedByWidth(long number, int width) {
        String slimResult;
        assert (number >= 0L);
        String numberString = Long.toString(number);
        int numberSize = numberString.length() + 2;
        if (numberSize <= width) {
            return numberString + "mb";
        }
        long base = number;
        double last = base * 1000L;
        int exponent = -2;
        String postFix = "";
        while (numberSize > width) {
            last = base;
            numberSize = Long.toString(base /= 1000L).length() + (++exponent > -1 ? 2 : 1);
            postFix = (exponent > -1 ? String.valueOf(ENCODED_POSTFIXES[exponent]) : "") + "b";
        }
        String withPrecision = this.format.format(last / 1000.0) + postFix;
        String withoutPrecision = Long.toString(base) + postFix;
        String string = slimResult = last % 1000.0 != 0.0 && withPrecision.length() <= width ? withPrecision : withoutPrecision;
        assert (slimResult.length() <= width);
        return slimResult;
    }

    public String toWideReadableForm(long number) {
        return this.toReadableFormRestrictedByWidth(number, 4);
    }

    static {
        $VALUES = new ReadableNumberConverterBuckets[]{INSTANCE};
        ENCODED_POSTFIXES = "KMGTPE".toCharArray();
    }
}

