/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.appliedfluidics.util.recipes;

import com.thiakil.appliedfluidics.FluidicsMod;
import com.thiakil.appliedfluidics.ModSettings;
import com.thiakil.appliedfluidics.item.ItemFluidDrop;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BucketProxyRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static UniversalBucket FORGE_BUCKET = ForgeModContainer.getInstance().universalBucket;
    private static List<Item> KNOWN_BUCKETS = Arrays.asList(Items.field_151131_as, Items.field_151129_at, Items.field_151117_aB);
    private Set<Fluid> bucketFluids;

    public void postInit() {
        this.bucketFluids = FluidRegistry.getBucketFluids();
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            ItemStack copy = itemstack.func_77946_l();
            copy.func_190920_e(Math.min(copy.func_190916_E(), 1));
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)copy);
            if (handler != null) {
                handler.drain(1000, true);
                aitemstack.set(i, (Object)handler.getContainer());
                continue;
            }
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)copy));
        }
        return aitemstack;
    }

    private InventoryCrafting getInvCopyIfFluids(InventoryCrafting inv) {
        InventoryCrafting invCopy = new InventoryCrafting((Container)new DummyContainer(), inv.func_174922_i(), inv.func_174923_h());
        boolean foundFluid = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            FluidStack contained;
            ItemStack invSlot = inv.func_70301_a(i);
            if (invSlot.func_190926_b()) {
                invCopy.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            Item invItem = invSlot.func_77973_b();
            if ((invItem == ItemFluidDrop.INSTANCE || ModSettings.proxyAllFluidContainers && !KNOWN_BUCKETS.contains(invItem)) && (contained = FluidUtil.getFluidContained((ItemStack)invSlot)) != null && contained.amount >= 1000) {
                Fluid fluid = contained.getFluid();
                if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || this.bucketFluids.contains(fluid)) {
                    foundFluid = true;
                    invCopy.func_70299_a(i, FluidUtil.getFilledBucket((FluidStack)contained));
                    continue;
                }
                return null;
            }
            invCopy.func_70299_a(i, invSlot);
        }
        return foundFluid ? invCopy : null;
    }

    private IRecipe getMatching(InventoryCrafting invCopy, World worldIn) {
        int invSize = invCopy.func_70302_i_();
        try {
            return CraftingManager.func_192413_b((InventoryCrafting)invCopy, (World)worldIn);
        }
        catch (StackOverflowError s) {
            FluidicsMod.logger.error("Whoops, looks like another IRecipe is scanning through the recipe list inside IRecipe.matches(), doing my best to prevent a crash!");
            return null;
        }
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        InventoryCrafting invCopy = this.getInvCopyIfFluids(inv);
        if (invCopy == null) {
            return false;
        }
        return this.getMatching(invCopy, worldIn) != null;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        InventoryCrafting invCopy = this.getInvCopyIfFluids(inv);
        if (invCopy == null) {
            return ItemStack.field_190927_a;
        }
        IRecipe matching = this.getMatching(invCopy, (World)DimensionManager.getWorld((int)0));
        return matching != null ? matching.func_77572_b(invCopy) : ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 9;
    }

    private static class DummyContainer
    extends Container {
        private DummyContainer() {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }

        public void func_75134_a(EntityPlayer playerIn) {
        }

        public void func_75130_a(IInventory inventoryIn) {
        }
    }
}

