/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.api;

import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;

public final class BackpackRegistry {
    public static final Map<Class<? extends EntityLivingBase>, Map<Item, Double>> entities = new HashMap<Class<? extends EntityLivingBase>, Map<Item, Double>>();

    private BackpackRegistry() {
    }

    public static void registerBackpackEntity(Class<? extends EntityLivingBase> entityClass, Object ... backpackChancePairs) {
        Map<Item, Double> entry = entities.get(entityClass);
        if (entry == null) {
            entry = new HashMap<Item, Double>();
            entities.put(entityClass, entry);
        }
        if (backpackChancePairs.length % 2 > 0) {
            throw new IllegalArgumentException("Number of backpack chance pairs is not even");
        }
        for (int i = 0; i < backpackChancePairs.length; i += 2) {
            if (!(backpackChancePairs[i] instanceof Item)) {
                throw new IllegalArgumentException("First argument in backpack chance pair is not an Item");
            }
            if (!(backpackChancePairs[i] instanceof IBackpackType)) {
                throw new IllegalArgumentException("First argument in backpack chance pair is not an IBackpackType");
            }
            if (!(backpackChancePairs[i + 1] instanceof Double)) {
                throw new IllegalArgumentException("Second argument in backpack chance pair is not a Double");
            }
            Item item = (Item)backpackChancePairs[i];
            double chance = (Double)backpackChancePairs[i + 1];
            if (chance > 0.0) {
                entry.put(item, chance);
                continue;
            }
            entry.remove(item);
        }
    }

    public static boolean canEntityWearBackpacks(Entity entity) {
        return entity instanceof EntityPlayer ? true : entities.containsKey(entity.getClass());
    }
}

