/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.api;

import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public interface IBackpackType {
    public void onSpawnedWith(EntityLivingBase var1, IBackpack var2);

    public void onEquip(EntityLivingBase var1, TileEntity var2, IBackpack var3);

    public void onUnequip(EntityLivingBase var1, TileEntity var2, IBackpack var3);

    public void onPlacedInteract(EntityPlayer var1, TileEntity var2, IBackpack var3);

    public void onEquippedInteract(EntityPlayer var1, EntityLivingBase var2, IBackpack var3);

    public void onEquippedTick(EntityLivingBase var1, IBackpack var2);

    public void onDeath(EntityLivingBase var1, IBackpack var2);

    public void onEquippedBroken(EntityLivingBase var1, IBackpack var2);

    public void onFaultyRemoval(EntityLivingBase var1, IBackpack var2);

    public void onBlockBreak(TileEntity var1, IBackpack var2);

    public IBackpackData createBackpackData(ItemStack var1);

    default public int getLidMaxTicks() {
        return 5;
    }

    default public float getLidAngle(int lidTicks, int prevLidTicks, float partialTicks) {
        float progress = (float)lidTicks + (float)(lidTicks - prevLidTicks) * partialTicks;
        progress = Math.max(0.0f, Math.min((float)this.getLidMaxTicks(), progress)) / (float)this.getLidMaxTicks();
        return (1.0f - (float)Math.pow(1.0f - progress, 2.0)) * 45.0f;
    }
}

