/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client;

import net.mcft.copy.backpacks.ProxyClient;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.mcft.copy.backpacks.block.entity.TileEntityBackpack;
import net.mcft.copy.backpacks.misc.util.IntermodUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public final class RendererBackpack {
    private static final ResourceLocation ENCHANTED_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RendererBackpack() {
    }

    private static void renderBackpack(IBackpack backpack, float ticks, boolean renderStraps) {
        ItemStack stack = backpack.getStack();
        int color = ProxyClient.ITEM_COLOR.func_186726_a(stack, 0);
        BlockModelRenderer renderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RendererBackpack.renderModel(backpack, renderer, ticks, renderStraps, r, g, b, false);
        if (stack.func_77948_v()) {
            RendererBackpack.renderEnchanted(backpack, renderer, ticks, renderStraps);
        }
    }

    private static void renderModel(IBackpack backpack, BlockModelRenderer renderer, float ticks, boolean renderStraps, float r, float g, float b, boolean useEnch) {
        IBakedModel baseModel = useEnch ? ProxyClient.MODEL_BACKPACK_ENCH : ProxyClient.MODEL_BACKPACK;
        renderer.func_178262_a(baseModel, 1.0f, r, g, b);
        if (renderStraps) {
            renderer.func_178262_a(ProxyClient.MODEL_BACKPACK_STRAPS, 1.0f, r, g, b);
        }
        float lidAngle = 0.0f;
        IBackpackType type = backpack.getType();
        if (type != null) {
            int lidTicks = backpack.getLidTicks();
            int prevLidTicks = backpack.getPrevLidTicks();
            lidAngle = type.getLidAngle(lidTicks, prevLidTicks, ticks % 1.0f);
        }
        float lidYOffset = 0.5625f;
        float lidZOffset = 0.3125f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)lidYOffset, (float)lidZOffset);
        GlStateManager.func_179114_b((float)lidAngle, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-lidYOffset), (float)(-lidZOffset));
        IBakedModel topModel = useEnch ? ProxyClient.MODEL_BACKPACK_ENCH_TOP : ProxyClient.MODEL_BACKPACK_TOP;
        renderer.func_178262_a(topModel, 1.0f, r, g, b);
        GlStateManager.func_179121_F();
    }

    private static void renderEnchanted(IBackpack backpack, BlockModelRenderer renderer, float ticks, boolean renderStraps) {
        Minecraft mc = Minecraft.func_71410_x();
        float glintStrength = WearableBackpacks.CONFIG.cosmetic.enchantEffectOpacity.get().floatValue();
        if (glintStrength <= 0.0f) {
            return;
        }
        float glintScale = 0.5f;
        float animProgress = ticks / 10.0f;
        int color = IntermodUtils.getRuneColor(backpack.getStack());
        float r = (float)(color >> 16 & 0xFF) / 255.0f * glintStrength;
        float g = (float)(color >> 8 & 0xFF) / 255.0f * glintStrength;
        float b = (float)(color & 0xFF) / 255.0f * glintStrength;
        mc.func_110434_K().func_110577_a(ENCHANTED_ITEM_GLINT);
        mc.field_71460_t.func_191514_d(true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179152_a((float)glintScale, (float)glintScale, (float)glintScale);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(animProgress * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            RendererBackpack.renderModel(backpack, renderer, ticks, renderStraps, r, g, b, true);
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179084_k();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        mc.field_71460_t.func_191514_d(false);
    }

    public static class Layer
    implements LayerRenderer<EntityLivingBase> {
        private static final float HEIGHT_OFFSET = 12.0f;
        private static final float DEPTH_OFFSET = 2.5f;

        public boolean func_177142_b() {
            return false;
        }

        public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            IBackpack backpack = BackpackHelper.getBackpack((Entity)entity);
            if (backpack == null) {
                return;
            }
            GlStateManager.func_179094_E();
            if (entity.func_70631_g_()) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            }
            float swingProgress = entity.func_70678_g(partialTicks);
            float swingAngle = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2))) * 0.2f;
            if (entity.field_184622_au == EnumHand.OFF_HAND ^ entity.func_184591_cq() == EnumHandSide.LEFT) {
                swingAngle *= -1.0f;
            }
            if (swingAngle != 0.0f) {
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(swingAngle)), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                GlStateManager.func_179114_b((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            GlStateManager.func_179109_b((float)(8.0f * scale), (float)(12.0f * scale), (float)(-2.5f * scale));
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RendererBackpack.renderBackpack(backpack, (float)entity.field_70173_aa + partialTicks, false);
            GlStateManager.func_179121_F();
        }
    }

    public static class TileEntity
    extends TileEntitySpecialRenderer<TileEntityBackpack> {
        public void render(TileEntityBackpack entity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
            IBackpack backpack = BackpackHelper.getBackpack(entity);
            if (backpack == null) {
                return;
            }
            float angle = entity.facing.func_185119_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            RendererBackpack.renderBackpack(backpack, (float)entity.getAge() + partialTicks, true);
            GlStateManager.func_179121_F();
        }
    }
}

