/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.config;

import java.util.Collections;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.client.config.EntryCategory;
import net.mcft.copy.backpacks.client.config.EntrySetting;
import net.mcft.copy.backpacks.client.config.ISlotCustomHeight;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.SettingSingleValue;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BackpacksGuiConfig
extends GuiConfig {
    public final String category;

    public BackpacksGuiConfig(GuiScreen parent) {
        this(parent, "general", "wearablebackpacks", false, false, "Wearable Backpacks", "");
    }

    public BackpacksGuiConfig(GuiScreen parentScreen, String category, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        super(parentScreen, Collections.emptyList(), modID, allRequireWorldRestart, allRequireMcRestart, title, titleLine2);
        this.category = category;
        this.func_73866_w_();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!(this.entryList instanceof Entries)) {
            this.entryList = new Entries(this);
        }
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 2000 && !(this.parentScreen instanceof GuiConfig)) {
            WearableBackpacks.CONFIG.getSettings().forEach(Setting::resetEntry);
        }
    }

    private static class Entries
    extends GuiConfigEntries {
        public Entries(BackpacksGuiConfig parent) {
            super((GuiConfig)parent, parent.field_146297_k);
            this.listEntries = WearableBackpacks.CONFIG.getSettings(parent.category).stream().map(setting -> EntrySetting.Create(this.owningScreen, this, (SettingSingleValue)setting)).collect(Collectors.toList());
            if (parent.category.equals("general")) {
                for (String cat : WearableBackpacks.CONFIG.getCategoryNames()) {
                    if (cat.equals("general")) continue;
                    this.listEntries.add(new EntryCategory(this.owningScreen, this, cat));
                }
            }
            super.initGui();
        }

        private int getHeightForSlot(int slot) {
            GuiConfigEntries.IConfigEntry entry = this.getListEntry(slot);
            return entry instanceof ISlotCustomHeight ? ((ISlotCustomHeight)entry).getSlotHeight() : this.func_148146_j();
        }

        public int func_148124_c(int posX, int posY) {
            if (posX < this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 || posX > this.func_148137_d()) {
                return -1;
            }
            int y = posY - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
            for (int slot = 0; slot < this.func_148127_b(); ++slot) {
                int slotHeight = this.getHeightForSlot(slot);
                if (y < slotHeight) {
                    return slot;
                }
                y -= slotHeight;
            }
            return -1;
        }

        protected int func_148138_e() {
            int height = this.field_148160_j;
            for (int slot = 0; slot < this.func_148127_b(); ++slot) {
                height += this.getHeightForSlot(slot);
            }
            return height;
        }
    }
}

