/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.config;

import java.util.List;
import java.util.Objects;
import net.mcft.copy.backpacks.client.GuiTextureResource;
import net.mcft.copy.backpacks.config.Setting;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class EntrySetting<T>
extends GuiConfigEntries.ListEntryBase {
    private static final GuiTextureResource CONFIG_ICONS = new GuiTextureResource("config_icons", 16, 16);
    public final Setting<T> setting;
    protected T value;
    private final HoverChecker _hintHoverChecker;
    private List<String> _hintTooltip = null;

    public EntrySetting(GuiConfig owningScreen, GuiConfigEntries owningEntryList, Setting<?> setting) {
        super(owningScreen, owningEntryList, setting.getConfigElement());
        this.setting = setting;
        this.setting.setEntry(this);
        this.value = this.setting.get();
        this._hintHoverChecker = new HoverChecker(0, 0, 0, 0, 400);
    }

    public static <T> EntrySetting<T> Create(GuiConfig owningScreen, GuiConfigEntries owningEntryList, Setting<T> setting) {
        String entryClassName = setting.getConfigEntryClass();
        if (entryClassName == null) {
            throw new RuntimeException("Setting '" + setting.getFullName() + "' has no entry class defined");
        }
        try {
            EntrySetting entry = (EntrySetting)((Object)Class.forName(entryClassName).getConstructor(GuiConfig.class, GuiConfigEntries.class, Setting.class).newInstance(owningScreen, owningEntryList, setting));
            entry.onValueChanged();
            return entry;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while instanciating setting entry for '" + setting.getFullName() + "' (entry class '" + entryClassName + "')", ex);
        }
    }

    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        this.tooltipHoverChecker.updateBounds(y, y + slotHeight, this.owningScreen.entryList.labelX - 2, this.owningScreen.entryList.controlX - 8);
        this._hintHoverChecker.updateBounds(y, y + 16, this.owningScreen.entryList.labelX - 20, this.owningScreen.entryList.labelX - 4);
        this._hintTooltip = this.setting.getRecommendationHint();
        if (this._hintTooltip != null) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            CONFIG_ICONS.bind();
            CONFIG_ICONS.drawQuad(this.owningScreen.entryList.labelX - 20, y, 0, 0, 16, 16);
        }
    }

    public void drawToolTip(int mouseX, int mouseY) {
        super.drawToolTip(mouseX, mouseY);
        if (this._hintTooltip != null && this._hintHoverChecker.checkHover(mouseX, mouseY)) {
            this.owningScreen.drawToolTip(this._hintTooltip, mouseX, mouseY);
        }
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.onValueChanged();
    }

    public void onValueChanged() {
    }

    public boolean enabled() {
        return super.enabled() && this.setting.isEnabledConfig();
    }

    public boolean isDefault() {
        return Objects.equals(this.value, this.setting.getDefault());
    }

    public void setToDefault() {
        if (!this.enabled()) {
            return;
        }
        this.setValue(this.setting.getDefault());
    }

    public boolean isChanged() {
        return !Objects.equals(this.value, this.setting.get());
    }

    public void undoChanges() {
        if (!this.enabled()) {
            return;
        }
        this.setValue(this.setting.get());
    }

    public boolean saveConfigElement() {
        if (!this.enabled() || !this.isChanged()) {
            return false;
        }
        this.setting.set(this.value);
        boolean reqRestart = this.setting.requiresMinecraftRestart();
        if (!reqRestart) {
            this.setting.update();
        }
        return reqRestart;
    }

    public Object getCurrentValue() {
        return Objects.toString(this.value);
    }

    public Object[] getCurrentValues() {
        return new Object[]{this.getCurrentValue()};
    }
}

