/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.config.custom;

import net.mcft.copy.backpacks.client.config.EntryButton;
import net.mcft.copy.backpacks.client.config.ISlotCustomHeight;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntryBackpackSize
extends EntryButton<BackpackSize>
implements ISlotCustomHeight {
    public EntryBackpackSize(GuiConfig owningScreen, GuiConfigEntries owningEntryList, Setting<BackpackSize> setting) {
        super(owningScreen, owningEntryList, setting, new Control());
        ((Control)this.button)._entry = this;
    }

    @Override
    public int getSlotHeight() {
        return this.button.field_146121_g + 2;
    }

    public static class Control
    extends GuiButtonExt {
        private boolean _dragging = false;
        protected EntryBackpackSize _entry;

        public Control() {
            super(0, 0, 0, 0, 0, "");
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            int slotSize = (this.field_146120_f - 8) / BackpackSize.MAX.getColumns();
            int offset = (this.field_146120_f - slotSize * BackpackSize.MAX.getColumns()) / 2;
            int x1 = this.field_146128_h + offset;
            int y1 = this.field_146129_i + offset;
            int x2 = x1 + BackpackSize.MAX.getColumns() * slotSize;
            int y2 = y1 + BackpackSize.MAX.getRows() * slotSize;
            if (this.field_146124_l && mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2) {
                this._entry.value = new BackpackSize(Math.min(Math.max(1 + (mouseX - x1) / slotSize, 1), BackpackSize.MAX.getColumns()), Math.min(Math.max(1 + (mouseY - y1) / slotSize, 1), BackpackSize.MAX.getRows()));
                this._dragging = true;
                return true;
            }
            return false;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            this._dragging = false;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            int slotSize = (this.field_146120_f - 8) / BackpackSize.MAX.getColumns();
            int offset = (this.field_146120_f - slotSize * BackpackSize.MAX.getColumns()) / 2;
            this.field_146121_g = slotSize * BackpackSize.MAX.getRows() + (this.field_146120_f - slotSize * BackpackSize.MAX.getColumns());
            if (!this.field_146125_m) {
                return;
            }
            if (this._dragging) {
                this._entry.value = new BackpackSize(Math.min(Math.max(1 + (mouseX - (this.field_146128_h + offset)) / slotSize, 1), BackpackSize.MAX.getColumns()), Math.min(Math.max(1 + (mouseY - (this.field_146129_i + offset)) / slotSize, 1), BackpackSize.MAX.getRows()));
            }
            BackpackSize value = (BackpackSize)this._entry.value;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)46, (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            for (int column = 1; column <= BackpackSize.MAX.getColumns(); ++column) {
                for (int row = 1; row <= BackpackSize.MAX.getRows(); ++row) {
                    boolean selected;
                    int xx = this.field_146128_h + offset + (column - 1) * slotSize;
                    int yy = this.field_146129_i + offset + (row - 1) * slotSize;
                    boolean hover = mouseX >= xx && mouseX < xx + slotSize && mouseY >= yy && mouseY < yy + slotSize;
                    boolean active = column <= value.getColumns() && row <= value.getRows();
                    boolean bl = selected = column == value.getColumns() && row == value.getRows();
                    if (!active && (!this.field_146124_l || !hover)) continue;
                    int texY = this.field_146124_l ? (hover ? 86 : 66) : 46;
                    int b = selected || !this.field_146124_l ? 0 : 1;
                    GuiUtils.drawContinuousTexturedBox((int)xx, (int)yy, (int)b, (int)(texY + b), (int)slotSize, (int)slotSize, (int)(200 - b * 2), (int)(20 - b * 2), (int)(2 - b), (int)(3 - b), (int)(2 - b), (int)(2 - b), (float)this.field_73735_i);
                }
            }
            int color = this.field_146124_l ? 0xFFFFFF : 0x707070;
            this.func_73732_a(mc.field_71466_p, value.toString(), this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
        }
    }
}

