/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcft.copy.backpacks.BackpacksContent;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.SettingBoolean;
import net.mcft.copy.backpacks.config.SettingInteger;
import net.mcft.copy.backpacks.config.custom.SettingBackpackSize;
import net.mcft.copy.backpacks.config.custom.SettingPercent;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.mcft.copy.backpacks.network.MessageSyncSettings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BackpacksConfig
extends Configuration {
    public final Setting<Boolean> equipAsChestArmor = new SettingBoolean(true).setSynced(value -> {
        BackpackHelper.equipAsChestArmor = value;
    }).setComment("If disabled, backpacks do not take up the player's chest armor equipment slot. Default: true.");
    public final Setting<Boolean> enableEquippedInteraction = new SettingBoolean(true).setComment("If enabled, allows equipped backpacks to be opened by other players by right clicking the target's back. Default: true.");
    public final Setting<Boolean> enableSelfInteraction = new SettingBoolean(false).setSynced().setComment("If enabled, allows players to open their own equipped backpack without requiring it to be placed first using a keybind. Default: false.");
    public final Setting<Boolean> dropAsBlockOnDeath = new SettingBoolean(true).setComment("If enabled, places equipped backpacks as a block on death, instead of scattering the items all around. Default: true.");
    public BackpackCategory backpack;
    @SideOnly(value=Side.CLIENT)
    public CosmeticCategory cosmetic;
    private Map<String, Setting<?>> _settings = new LinkedHashMap();

    public BackpacksConfig(File file) {
        super(file);
        this.addSettingsFromClass((Object)this, "general");
        for (Field field : ((Object)((Object)this)).getClass().getFields()) {
            if (field.getDeclaringClass() != ((Object)((Object)this)).getClass() || !field.getType().getName().endsWith("Category")) continue;
            try {
                field.set((Object)this, field.getType().getConstructors()[0].newInstance(new Object[]{this}));
                this.addSettingsFromClass(field.get((Object)this), field.getName());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void addSettingsFromClass(Object instance, String category) {
        for (Field field : instance.getClass().getFields()) {
            Setting setting;
            if (!Setting.class.isAssignableFrom(field.getType())) continue;
            try {
                setting = (Setting)field.get(instance);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            setting.init(category, field.getName());
            this._settings.put(setting.getFullName(), setting);
        }
    }

    public Setting<?> getSetting(String fullName) {
        return this._settings.get(fullName);
    }

    public Collection<Setting<?>> getSettings() {
        return this._settings.values();
    }

    public Collection<Setting<?>> getSettings(String category) {
        return this.getSettings().stream().filter(setting -> setting.getCategory().equals(category)).collect(Collectors.toList());
    }

    public void load() {
        if (this._settings == null) {
            return;
        }
        super.load();
        if (this.getCategory("backpack").containsKey("rows")) {
            int rows = this.get("backpack", "rows", 4).getInt();
            this.get("backpack", "size", "").set(new BackpackSize(9, rows).toString());
            this.getCategory("backpack").remove((Object)"rows");
        }
        this.getSettings().forEach(setting -> setting.loadFromConfiguration(this));
    }

    public void save() {
        Map byCategory = this.getSettings().stream().collect(Collectors.groupingBy(setting -> setting.getCategory(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : byCategory.entrySet()) {
            String category = (String)entry.getKey();
            if (category.equals("general")) continue;
            List order = ((List)entry.getValue()).stream().map(Setting::getName).collect(Collectors.toList());
            this.setCategoryPropertyOrder(category, order);
        }
        this.getCategory("general").remove((Object)"enableHelpTooltips");
        this.getSettings().forEach(setting -> setting.saveToConfiguration(this));
        super.save();
    }

    public void init() {
        this.getSettings().forEach(Setting::update);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("wearablebackpacks")) {
            return;
        }
        if (event.isWorldRunning()) {
            WearableBackpacks.CHANNEL.sendToAll(MessageSyncSettings.create());
        }
        this.save();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        WearableBackpacks.CHANNEL.sendTo(MessageSyncSettings.create(), event.player);
    }

    @SubscribeEvent
    public void onDisconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.getSettings().forEach(Setting::resetSynced);
    }

    @SideOnly(value=Side.CLIENT)
    public class CosmeticCategory {
        public final Setting<Double> enchantEffectOpacity = new SettingPercent(0.8).setConfigEntryClass("net.mcft.copy.backpacks.client.config.custom.EntryEffectOpacity").setComment("Controls the opacity / visibility of the enchantment effect on equipped and placed backpacks, if present. Default: 80%.");
    }

    public class BackpackCategory {
        public final Setting<Boolean> enabled = new SettingBoolean(true).setRequiresMinecraftRestart();
        public final Setting<Integer> durability;
        public final Setting<Integer> armor;
        public final Setting<BackpackSize> size;

        public BackpackCategory() {
            this.durability = new SettingInteger(214).setValidRange(0, Integer.MAX_VALUE).setRequired(this.enabled).setRecommended(BackpacksConfig.this.equipAsChestArmor).setSynced(value -> BackpacksContent.BACKPACK.func_77656_e((int)value)).setComment("Durability of a normal backpack. Set to 0 for unbreakable. Default: 214.\nLowering this (including setting to 0) can cause issues with already damaged backpacks.");
            this.armor = new SettingInteger(2).setValidRange(0, 20).setRequired(this.enabled).setRecommended(BackpacksConfig.this.equipAsChestArmor).setSynced().setConfigEntryClass("net.mcft.copy.backpacks.client.config.custom.EntryArmor").setComment("Armor points of a normal backpack. Valid values are 0 to 20. Default: 2.\nHas no effect if equipAsChestArmor is disabled.");
            this.size = new SettingBackpackSize(9, 4).setRequired(this.enabled).setComment("Storage size of a normal backpack. Valid values are [1x1] to [17x6]. Default: [9x4].\nChanging this doesn't affect placed or equipped backpacks until turned back into an item.");
        }
    }
}

