/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.mcft.copy.backpacks.client.config.EntrySetting;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Setting<T> {
    private static boolean _checkEntryValue = false;
    private final T _defaultValue;
    private T _value;
    @SideOnly(value=Side.CLIENT)
    private EntrySetting<T> _entry;
    private String _category;
    private String _name;
    private BooleanSupplier _requireFunc = () -> true;
    private boolean _requiresWorldRejoin = false;
    private boolean _requiresMinecraftRestart = false;
    private Supplier<List<String>> _recommendFunc = () -> null;
    private boolean _doesSync = false;
    private boolean _isSynced = false;
    private T _syncedValue = null;
    private Consumer<T> _updateAction = null;
    private String _configEntryClass = null;
    private String _comment = null;

    public Setting(T defaultValue) {
        this._defaultValue = defaultValue;
    }

    protected void init(String category, String name) {
        this._category = category;
        this._name = name;
    }

    public final Setting<T> setRequirement(BooleanSupplier requireFunc) {
        this._requireFunc = requireFunc;
        return this;
    }

    @SafeVarargs
    public final Setting<T> setRequired(Setting<Boolean> ... settings) {
        return this.setRequirement(() -> Arrays.asList(settings).stream().allMatch(setting -> (Boolean)setting.get()));
    }

    public Setting<T> setRequiresWorldRejoin() {
        this._requiresWorldRejoin = true;
        return this;
    }

    public Setting<T> setRequiresMinecraftRestart() {
        this._requiresMinecraftRestart = true;
        return this;
    }

    public final Setting<T> setRecommendation(Supplier<List<String>> recommendFunc) {
        this._recommendFunc = recommendFunc;
        return this;
    }

    @SafeVarargs
    public final Setting<T> setRecommended(Setting<Boolean> ... settings) {
        return this.setRecommendation(() -> {
            if (Arrays.asList(settings).stream().allMatch(setting -> (Boolean)setting.get())) {
                return null;
            }
            String key = "config.wearablebackpacks." + this.getFullName() + ".hint";
            ArrayList<String> tooltip = new ArrayList<String>(Arrays.asList((TextFormatting.YELLOW + I18n.func_135052_a((String)key, (Object[])new Object[0])).split("\\\\n")));
            for (Setting setting2 : settings) {
                if (((Boolean)setting2.get()).booleanValue()) continue;
                tooltip.add(TextFormatting.AQUA + "[" + setting2.getFullName() + " = false]");
            }
            return tooltip;
        });
    }

    public Setting<T> setSynced() {
        this._doesSync = true;
        return this;
    }

    public Setting<T> setSynced(Consumer<T> action) {
        this.setSynced();
        return this.setUpdate(action);
    }

    public Setting<T> setUpdate(Consumer<T> action) {
        this._updateAction = action;
        return this;
    }

    public Setting<T> setConfigEntryClass(String entryClass) {
        this._configEntryClass = entryClass;
        return this;
    }

    public Setting<T> setComment(String comment) {
        this._comment = comment;
        return this;
    }

    public String getCategory() {
        return this._category;
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._category + "." + this._name;
    }

    public T getDefault() {
        return this._defaultValue;
    }

    public T get() {
        return _checkEntryValue ? this.getEntryValue() : (this._isSynced ? this._syncedValue : this._value);
    }

    public void set(T value) {
        this._value = value;
    }

    public boolean isEnabled() {
        return this._requireFunc.getAsBoolean();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isEnabledConfig() {
        _checkEntryValue = true;
        boolean enabled = this.isEnabled();
        _checkEntryValue = false;
        return enabled;
    }

    public boolean requiresWorldRejoin() {
        return this._requiresWorldRejoin;
    }

    public boolean requiresMinecraftRestart() {
        return this._requiresMinecraftRestart;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getRecommendationHint() {
        _checkEntryValue = true;
        List<String> hintTooltip = this._recommendFunc.get();
        _checkEntryValue = false;
        return hintTooltip;
    }

    public boolean doesSync() {
        return this._doesSync;
    }

    public boolean isSynced() {
        return this._isSynced;
    }

    public String getConfigEntryClass() {
        return this._configEntryClass;
    }

    public String getComment() {
        return this._comment;
    }

    private T getEntryValue() {
        return this._entry.getValue();
    }

    @SideOnly(value=Side.CLIENT)
    public void setEntry(EntrySetting<T> entry) {
        this._entry = entry;
    }

    @SideOnly(value=Side.CLIENT)
    public void resetEntry() {
        this._entry = null;
    }

    public void update() {
        if (this._updateAction != null && this.isEnabled()) {
            this._updateAction.accept(this._value);
        }
    }

    public IConfigElement getConfigElement() {
        return new ConfigElement();
    }

    protected abstract void loadFromConfiguration(Configuration var1);

    protected abstract void saveToConfiguration(Configuration var1);

    public void readSynced(NBTBase tag) {
        this._isSynced = true;
        this._syncedValue = this.read(tag);
        if (this._updateAction != null) {
            this._updateAction.accept(this._syncedValue);
        }
    }

    public NBTBase writeSynced() {
        return this.write(this._value);
    }

    protected void resetSynced() {
        this._isSynced = false;
        this._syncedValue = null;
    }

    public abstract T read(NBTBase var1);

    public abstract NBTBase write(T var1);

    public class ConfigElement
    implements IConfigElement {
        public boolean isProperty() {
            return true;
        }

        public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
            return null;
        }

        public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
            return null;
        }

        public String getName() {
            return Setting.this.getName();
        }

        public String getQualifiedName() {
            return Setting.this.getFullName();
        }

        public String getLanguageKey() {
            return "config.wearablebackpacks." + Setting.this.getFullName();
        }

        public String getComment() {
            return Setting.this.getComment();
        }

        public List<IConfigElement> getChildElements() {
            return null;
        }

        public ConfigGuiType getType() {
            return null;
        }

        public boolean isList() {
            return false;
        }

        public boolean isListLengthFixed() {
            return false;
        }

        public int getMaxListLength() {
            return 0;
        }

        public boolean isDefault() {
            return Objects.equals(Setting.this.get(), Setting.this.getDefault());
        }

        public Object getDefault() {
            return Setting.this.getDefault();
        }

        public Object[] getDefaults() {
            return null;
        }

        public void setToDefault() {
            this.set(Setting.this.getDefault());
        }

        public boolean requiresWorldRestart() {
            return Setting.this.requiresWorldRejoin();
        }

        public boolean requiresMcRestart() {
            return Setting.this.requiresMinecraftRestart();
        }

        public boolean showInGui() {
            return true;
        }

        public Object get() {
            return Setting.this.get();
        }

        public Object[] getList() {
            return null;
        }

        public void set(Object value) {
            Setting.this.set(value);
        }

        public void set(Object[] aVal) {
        }

        public String[] getValidValues() {
            return null;
        }

        public Object getMinValue() {
            return null;
        }

        public Object getMaxValue() {
            return null;
        }

        public Pattern getValidationPattern() {
            return null;
        }
    }
}

