/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.config;

import net.mcft.copy.backpacks.config.SettingSingleValue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraftforge.common.config.Property;

public class SettingDouble
extends SettingSingleValue<Double> {
    private double _minValue = Double.NEGATIVE_INFINITY;
    private double _maxValue = Double.POSITIVE_INFINITY;

    public double getMinValue() {
        return this._minValue;
    }

    public double getMaxValue() {
        return this._maxValue;
    }

    public SettingDouble(double defaultValue) {
        super(defaultValue);
        this.setConfigEntryClass("net.mcft.copy.backpacks.client.config.EntryField$Decimal");
    }

    public SettingDouble setValidRange(double min, double max) {
        this._minValue = min;
        this._maxValue = max;
        return this;
    }

    @Override
    protected Property.Type getPropertyType() {
        return Property.Type.DOUBLE;
    }

    @Override
    public Double parse(String str) {
        double i = Double.parseDouble(str);
        if (i < this._minValue || i > this._maxValue) {
            throw new IllegalArgumentException("Not within valid bounds [" + this._minValue + "," + this._maxValue + "]");
        }
        return i;
    }

    @Override
    public Double read(NBTBase tag) {
        return ((NBTTagDouble)tag).func_150286_g();
    }

    @Override
    public NBTBase write(Double value) {
        return new NBTTagDouble(value.doubleValue());
    }
}

