/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.misc.BackpackSize;
import net.mcft.copy.backpacks.misc.util.NbtUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackDataItems
implements IBackpackData {
    public static final String TAG_SIZE = "size";
    public static final String TAG_ITEMS = "items";
    public static final String TAG_LOOT_TABLE = "LootTable";
    public static final String TAG_LOOT_TABLE_SEED = "LootTableSeed";
    private BackpackSize _size;
    private ItemStackHandler _items = null;
    private ResourceLocation _lootTable = null;
    private long _lootTableSeed = 0L;

    public BackpackDataItems() {
    }

    public BackpackDataItems(int columns, int rows) {
        this(new BackpackSize(columns, rows));
    }

    public BackpackDataItems(BackpackSize size) {
        this._size = size;
    }

    public BackpackSize getSize() {
        return this._size;
    }

    public ItemStackHandler getItems() {
        return this.getItems(null, null);
    }

    public ItemStackHandler getItems(World world, EntityPlayer player) {
        if (this._items == null) {
            this._items = new ItemStackHandler(this._size.getColumns() * this._size.getRows());
            if (this._lootTable != null) {
                BackpackDataItems.generateLoot(this._items, this._lootTable, this._lootTableSeed, world, player);
                this._lootTable = null;
            }
        }
        return this._items;
    }

    public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        if (this._items != null) {
            throw new UnsupportedOperationException();
        }
        this._lootTable = lootTable;
        this._lootTableSeed = lootTableSeed;
    }

    public static void generateLoot(ItemStackHandler items, ResourceLocation tableLoc, long seed, World world, EntityPlayer player) {
        int i;
        Random rnd = new Random(seed);
        double maxFullness = 0.6 + rnd.nextDouble() * 0.2;
        int maxOccupiedSlots = (int)Math.ceil((double)items.getSlots() * maxFullness);
        LootTableManager manager = world.func_184146_ak();
        LootTable table = manager.func_186521_a(tableLoc);
        LootContext context = new LootContext(player != null ? player.func_184817_da() : 0.0f, (WorldServer)world, manager, (Entity)player, null, null);
        List loot = table.func_186462_a(rnd, context);
        Collections.shuffle(loot);
        ArrayList<Integer> randomizedSlots = new ArrayList<Integer>(items.getSlots());
        for (i = 0; i < items.getSlots(); ++i) {
            randomizedSlots.add(i);
        }
        Collections.shuffle(randomizedSlots);
        for (i = 0; i < maxOccupiedSlots && i < loot.size(); ++i) {
            ItemStack stack = (ItemStack)loot.get(i);
            int slot = (Integer)randomizedSlots.get(i);
            items.setStackInSlot(slot, stack);
        }
    }

    public NBTBase serializeNBT() {
        return NbtUtils.createCompound(TAG_SIZE, this._size.serializeNBT(), TAG_ITEMS, this._items != null ? this._items.serializeNBT() : null, TAG_LOOT_TABLE, this._lootTable != null ? this._lootTable.toString() : null, TAG_LOOT_TABLE_SEED, this._lootTable != null ? Long.valueOf(this._lootTableSeed) : null);
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        if (compound.func_74764_b(TAG_SIZE)) {
            this._size = BackpackSize.parse(compound.func_74781_a(TAG_SIZE));
            if (compound.func_74764_b(TAG_ITEMS)) {
                this.getItems().deserializeNBT(compound.func_74775_l(TAG_ITEMS));
            } else if (compound.func_74764_b(TAG_LOOT_TABLE)) {
                this._lootTable = new ResourceLocation(compound.func_74779_i(TAG_LOOT_TABLE));
                this._lootTableSeed = compound.func_74763_f(TAG_LOOT_TABLE_SEED);
            }
        } else {
            this.getItems().deserializeNBT(compound);
            this._size = new BackpackSize(9, this._items.getSlots() / 9);
        }
    }
}

