/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public final class IntermodUtils {
    private static boolean getRuneColorCached = false;
    private static Method setTargetStackMethod;
    private static Method getColorMethod;

    private IntermodUtils() {
    }

    public static int getRuneColor(ItemStack stack) {
        if (!getRuneColorCached) {
            if (Loader.isModLoaded((String)"quark")) {
                try {
                    Class<?> clazz = Class.forName("vazkii.quark.misc.feature.ColorRunes");
                    setTargetStackMethod = clazz.getMethod("setTargetStack", ItemStack.class);
                    getColorMethod = clazz.getMethod("getColor", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException ex) {
                    WearableBackpacks.LOG.error("Error while fetching Quark ColorRunes methods", (Throwable)ex);
                }
            } else {
                setTargetStackMethod = null;
                getColorMethod = null;
            }
            getRuneColorCached = true;
        }
        if (setTargetStackMethod == null) {
            return -8372020;
        }
        try {
            setTargetStackMethod.invoke(null, stack);
            return (Integer)getColorMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            WearableBackpacks.LOG.error("Error while invoking Quark ColorRunes methods", (Throwable)ex);
            setTargetStackMethod = null;
            getColorMethod = null;
            return -8372020;
        }
    }
}

