/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.network;

import io.netty.buffer.ByteBuf;
import net.mcft.copy.backpacks.WearableBackpacks;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.network.BackpacksMessageHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncSettings
implements IMessage {
    private NBTTagCompound _data;

    public static MessageSyncSettings create() {
        MessageSyncSettings message = new MessageSyncSettings();
        message._data = new NBTTagCompound();
        for (Setting<?> setting : WearableBackpacks.CONFIG.getSettings()) {
            if (!setting.doesSync() || !setting.isEnabled()) continue;
            message._data.func_74782_a(setting.getFullName(), setting.writeSynced());
        }
        return message;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            this._data = buffer.func_150793_b();
        }
        catch (Exception ex) {
            this._data = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_150786_a(this._data);
    }

    public static class Handler
    extends BackpacksMessageHandler<MessageSyncSettings> {
        @Override
        public boolean isScheduled() {
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handle(MessageSyncSettings message, MessageContext ctx) {
            for (String key : message._data.func_150296_c()) {
                NBTBase tag = message._data.func_74781_a(key);
                Setting<?> setting = WearableBackpacks.CONFIG.getSetting(key);
                if (setting == null || !setting.doesSync()) continue;
                setting.readSynced(tag);
            }
        }
    }
}

