/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import reborncore.api.power.IPowerConfig;

public class RebornCoreConfig {
    public static Configuration config;
    public static String CATEGORY_POWER;
    public static String CATEGORY_MISC;
    public static int euPerFU;
    public static boolean ShowStackInfoHUD;
    public static boolean stackInfoBottom;
    public static int stackInfoX;
    public static int stackInfoY;
    public static boolean versionCheck;
    public static boolean easterEggs;
    protected static boolean enableEU;
    protected static boolean enableTesla;
    protected static boolean enableForge;
    private static RebornCoreConfig instance;
    private static IPowerConfig powerConfig;
    public static boolean mtDocGen;
    public static boolean isIC2Loaded;
    public static boolean wrenchRequired;

    public RebornCoreConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        RebornCoreConfig.Configs();
        config.save();
    }

    public static RebornCoreConfig initialize(File configFile) {
        if (instance != null) {
            throw new IllegalStateException("Cannot initialize TechReborn Config twice");
        }
        instance = new RebornCoreConfig(configFile);
        return instance;
    }

    public static RebornCoreConfig instance() {
        if (instance == null) {
            throw new IllegalStateException("Instance of TechReborn Config requested before initialization");
        }
        return instance;
    }

    public static void Configs() {
        enableTesla = config.get(CATEGORY_POWER, "Allow Tesla", false, "Allow machines to be powered with Tesla").getBoolean();
        enableForge = config.get(CATEGORY_POWER, "Allow Forge", true, "Allow machines to be powered with Forges power system").getBoolean();
        enableEU = config.get(CATEGORY_POWER, "Allow IC2 EU", true, "Allow machines to be powered with EU").getBoolean();
        euPerFU = config.get(CATEGORY_POWER, "EU - FU ratio", 4, "The Amount of FU to output from EU").getInt();
        versionCheck = config.get(CATEGORY_MISC, "Check for new versions", true, "Enable version checker").getBoolean();
        ShowStackInfoHUD = config.get(CATEGORY_POWER, "Show Stack Info HUD", true, "Show Stack Info HUD (ClientSideOnly)").getBoolean(true);
        stackInfoBottom = config.get(CATEGORY_POWER, "Stack Info Bottom", true, "Reverse the order of the HUD, and calculate it's X and Y positions from the bottom left corner (ClientSideOnly)").getBoolean(true);
        stackInfoX = config.get(CATEGORY_POWER, "Stack Info X", 2, "X coordinate of the stack hud (ClientSideOnly)").getInt();
        stackInfoY = config.get(CATEGORY_POWER, "Stack Info Y", 7, "Y coordinate of the stack hud (ClientSideOnly)").getInt();
        easterEggs = config.get(CATEGORY_MISC, "Enable Seasonal Easter Eggs", true, "Disable this is you don't want seasonal easter eggs").getBoolean();
        mtDocGen = config.get(CATEGORY_MISC, "mtDocGen", false, "Enable automatic generation of MT docs at runtime (Beta)").getBoolean();
        powerConfig = null;
        wrenchRequired = config.get(CATEGORY_MISC, "Wrench required", true, "Wrench required to pick machine. If now wrenched than machine frame will drop instead.").getBoolean(true);
    }

    public static IPowerConfig getRebornPower() {
        if (powerConfig == null) {
            powerConfig = new IPowerConfig(){

                @Override
                public boolean eu() {
                    return enableEU;
                }

                @Override
                public boolean tesla() {
                    return enableTesla;
                }

                @Override
                public boolean internal() {
                    return true;
                }

                @Override
                public boolean forge() {
                    return enableForge;
                }
            };
        }
        return powerConfig;
    }

    static {
        CATEGORY_POWER = "power";
        CATEGORY_MISC = "misc";
        instance = null;
        powerConfig = null;
        isIC2Loaded = false;
        wrenchRequired = true;
    }
}

