/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.PacketWrapper;
import reborncore.common.network.RegisterPacketEvent;

public class NetworkManager {
    public static final SimpleNetworkWrapper NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("rebornCore");
    public static HashMap<Integer, Class<? extends INetworkPacket>> packetHashMap = new HashMap();
    public static HashMap<Class<? extends INetworkPacket>, Integer> packetHashMapReverse = new HashMap();

    public static void load() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterPacketEvent(NETWORK_WRAPPER));
    }

    public static void sendToServer(INetworkPacket packet) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendToServer((IMessage)new PacketWrapper(packet));
    }

    public static void sendToAllAround(INetworkPacket packet, NetworkRegistry.TargetPoint point) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendToAllAround((IMessage)new PacketWrapper(packet), point);
    }

    public static void sendToAll(INetworkPacket packet) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendToAll((IMessage)new PacketWrapper(packet));
    }

    public static void sendToPlayer(INetworkPacket packet, EntityPlayerMP playerMP) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendTo((IMessage)new PacketWrapper(packet), playerMP);
    }

    public static void sendToWorld(INetworkPacket packet, World world) {
        if (!packetHashMap.containsValue(packet.getClass())) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
        NETWORK_WRAPPER.sendToDimension((IMessage)new PacketWrapper(packet), world.field_73011_w.getDimension());
    }
}

