/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import reborncore.RebornCore;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.tesla.TeslaManager;
import reborncore.common.util.serialization.SerializationUtil;

public class PowerSystem {
    public static File priorityConfig;
    private static int euPriority;
    private static int teslaPriority;
    private static int forgePriority;
    private static int euPriorityDefault;
    private static int teslaPriorityDefault;
    private static int forgePriorityDefault;

    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPowerNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerNoSuffix((int)eu);
    }

    public static String getLocaliszedPowerFormatted(double eu) {
        return PowerSystem.getLocaliszedPowerFormatted((int)eu);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return eu + " " + EnergySystem.EU.abbreviation;
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return eu * RebornCoreConfig.euPerFU + " " + EnergySystem.TESLA.abbreviation;
        }
        return eu * RebornCoreConfig.euPerFU + " " + EnergySystem.FE.abbreviation;
    }

    public static String getLocaliszedPowerFormatted(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu) + " " + EnergySystem.EU.abbreviation;
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU) + " " + EnergySystem.TESLA.abbreviation;
        }
        return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU) + " " + EnergySystem.FE.abbreviation;
    }

    public static String getLocaliszedPowerFormattedNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu);
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU);
        }
        return NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(eu * RebornCoreConfig.euPerFU);
    }

    public static String getLocaliszedPowerNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.EU)) {
            return eu + "";
        }
        if (PowerSystem.getDisplayPower().equals((Object)EnergySystem.TESLA)) {
            return eu * RebornCoreConfig.euPerFU + "";
        }
        return eu * RebornCoreConfig.euPerFU + "";
    }

    private static String getRoundedString(double euValue, String units) {
        if (euValue >= 1000000.0) {
            double tenX = Math.round(euValue / 100000.0);
            return Double.toString(tenX / 10.0).concat(" m " + units);
        }
        if (euValue >= 1000.0) {
            double tenX = Math.round(euValue / 100.0);
            return Double.toString(tenX / 10.0).concat(" k " + units);
        }
        return Double.toString(Math.floor(euValue)).concat(" " + units);
    }

    public static EnergySystem getDisplayPower() {
        int eu = euPriority;
        int tesla = teslaPriority;
        int fe = forgePriority;
        if ((eu > tesla || !TeslaManager.isTeslaEnabled(RebornCoreConfig.getRebornPower())) && eu > fe && RebornCoreConfig.getRebornPower().eu()) {
            return EnergySystem.EU;
        }
        if ((tesla > eu || !RebornCoreConfig.getRebornPower().eu()) && tesla > fe && TeslaManager.isTeslaEnabled(RebornCoreConfig.getRebornPower())) {
            return EnergySystem.TESLA;
        }
        return EnergySystem.FE;
    }

    public static void bumpPowerConfig() {
        EnergyPriorityConfig config = new EnergyPriorityConfig();
        if (PowerSystem.getDisplayPower() == EnergySystem.TESLA) {
            config.setEuPriority(2);
            config.setTeslaPriority(0);
            config.setForgePriority(1);
        } else if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            config.setEuPriority(0);
            config.setTeslaPriority(1);
            config.setForgePriority(2);
        } else if (PowerSystem.getDisplayPower() == EnergySystem.FE) {
            config.setEuPriority(1);
            config.setTeslaPriority(2);
            config.setForgePriority(0);
        }
        PowerSystem.writeConfig(config);
    }

    public static void reloadConfig() {
        if (!priorityConfig.exists()) {
            PowerSystem.writeConfig(new EnergyPriorityConfig());
        }
        if (priorityConfig.exists()) {
            EnergyPriorityConfig config = null;
            try (FileReader reader = new FileReader(priorityConfig);){
                config = (EnergyPriorityConfig)SerializationUtil.GSON.fromJson((Reader)reader, EnergyPriorityConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                RebornCore.logHelper.error("Failed to read power config, will reset to defautls and save a new file.");
            }
            if (config == null) {
                config = new EnergyPriorityConfig();
                PowerSystem.writeConfig(config);
            }
            euPriority = config.euPriority;
            teslaPriority = config.teslaPriority;
            forgePriority = config.forgePriority;
        }
    }

    public static void writeConfig(EnergyPriorityConfig config) {
        try (FileWriter writer = new FileWriter(priorityConfig);){
            SerializationUtil.GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PowerSystem.reloadConfig();
    }

    static /* synthetic */ int access$000() {
        return euPriorityDefault;
    }

    static /* synthetic */ int access$100() {
        return teslaPriorityDefault;
    }

    static /* synthetic */ int access$200() {
        return forgePriorityDefault;
    }

    static {
        euPriorityDefault = 0;
        teslaPriorityDefault = 2;
        forgePriorityDefault = 1;
    }

    public static class EnergyPriorityConfig {
        public int euPriority = PowerSystem.access$000();
        public int teslaPriority = PowerSystem.access$100();
        public int forgePriority = PowerSystem.access$200();

        public int getEuPriority() {
            return this.euPriority;
        }

        public void setEuPriority(int euPriority) {
            this.euPriority = euPriority;
        }

        public int getTeslaPriority() {
            return this.teslaPriority;
        }

        public void setTeslaPriority(int teslaPriority) {
            this.teslaPriority = teslaPriority;
        }

        public int getForgePriority() {
            return this.forgePriority;
        }

        public void setForgePriority(int forgePriority) {
            this.forgePriority = forgePriority;
        }
    }

    public static enum EnergySystem {
        TESLA(-14440563, "Tesla", 71, 151, -15630496),
        EU(-8387072, "EU", 43, 151, -10027008),
        FE(-4315110, "FE", 15, 151, -6943475);

        public int colour;
        public int altColour;
        public String abbreviation;
        public int xBar;
        public int yBar;

        private EnergySystem(int colour, String abbreviation, int xBar, int yBar, int altColour) {
            this.colour = colour;
            this.abbreviation = abbreviation;
            this.xBar = xBar;
            this.yBar = yBar;
            this.altColour = altColour;
        }
    }
}

