/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.registration;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import reborncore.common.registration.IRegistryFactory;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.RegistryTarget;

public class RegistrationManager {
    static HashMap<Class<? extends FMLStateEvent>, IRegistryFactory> factoryList = new HashMap();
    static List<Class> registryClasses = new ArrayList<Class>();

    public static void init(FMLPreInitializationEvent event) {
        long start = System.currentTimeMillis();
        ASMDataTable asmDataTable = event.getAsmData();
        RegistrationManager.loadFactorys(asmDataTable);
        Set asmDataSet = asmDataTable.getAll(RebornRegistry.class.getName());
        for (ASMDataTable.ASMData data : asmDataSet) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                registryClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(registryClasses, Comparator.comparing(Class::getCanonicalName));
        for (IRegistryFactory registryFactory : RegistrationManager.getFactorysForSate(event.getClass())) {
            if (!registryFactory.getTargets().contains((Object)RegistryTarget.CLASS)) continue;
            Set asmDataFactorySet = asmDataTable.getAll(registryFactory.getAnnotation().getName());
            for (ASMDataTable.ASMData data : asmDataFactorySet) {
                try {
                    ModContainer activeContainer = Loader.instance().activeModContainer();
                    Class<?> factoryClazz = Class.forName(data.getClassName());
                    Annotation annotation = RegistrationManager.getAnnoation(factoryClazz.getAnnotations(), RebornRegistry.class);
                    if (annotation instanceof RebornRegistry) {
                        RebornRegistry registryAnnotation = (RebornRegistry)annotation;
                        String modId = registryAnnotation.modID();
                        if (!activeContainer.getModId().equals(modId)) {
                            RegistrationManager.setActiveMod(modId);
                        }
                    }
                    registryFactory.handleClass(factoryClazz);
                    RegistrationManager.setActiveModContainer(activeContainer);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        FMLLog.info((String)("Pre loaded registries in" + (System.currentTimeMillis() - start) + "ms"), (Object[])new Object[0]);
    }

    public static void load(FMLStateEvent event) {
        long start = System.currentTimeMillis();
        ModContainer activeMod = Loader.instance().activeModContainer();
        List<IRegistryFactory> factoryList = RegistrationManager.getFactorysForSate(event.getClass());
        if (!factoryList.isEmpty()) {
            for (Class clazz : registryClasses) {
                RebornRegistry annotation = (RebornRegistry)RegistrationManager.getAnnoation(clazz.getAnnotations(), RebornRegistry.class);
                if (annotation != null && !activeMod.getModId().equals(annotation.modID())) {
                    RegistrationManager.setActiveMod(annotation.modID());
                }
                for (Field field : clazz.getDeclaredFields()) {
                    for (IRegistryFactory regFactory : factoryList) {
                        if (!regFactory.getTargets().contains((Object)RegistryTarget.FIELD) || !field.isAnnotationPresent(regFactory.getAnnotation())) continue;
                        regFactory.handleField(field);
                    }
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    for (IRegistryFactory regFactory : factoryList) {
                        if (!regFactory.getTargets().contains((Object)RegistryTarget.MEHTOD) || !accessibleObject.isAnnotationPresent(regFactory.getAnnotation())) continue;
                        regFactory.handleMethod((Method)accessibleObject);
                    }
                }
            }
            RegistrationManager.setActiveModContainer(activeMod);
        }
        FMLLog.info((String)("Loaded registrys for " + event.getClass().getName() + " in " + (System.currentTimeMillis() - start) + "ms"), (Object[])new Object[0]);
    }

    private static List<IRegistryFactory> getFactorysForSate(Class<? extends FMLStateEvent> event) {
        ArrayList<IRegistryFactory> factorySateList = new ArrayList<IRegistryFactory>();
        for (Map.Entry<Class<? extends FMLStateEvent>, IRegistryFactory> entry : factoryList.entrySet()) {
            if (entry.getKey() != event) continue;
            factorySateList.add(entry.getValue());
        }
        return factorySateList;
    }

    public static Annotation getAnnoationFromArray(Annotation[] annotations, IRegistryFactory factory) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != factory.getAnnotation()) continue;
            return annotation;
        }
        return null;
    }

    public static Annotation getAnnoation(Annotation[] annotations, Class annoation) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annoation) continue;
            return annotation;
        }
        return null;
    }

    private static void loadFactorys(ASMDataTable dataTable) {
        Set asmDataSet = dataTable.getAll(IRegistryFactory.RegistryFactory.class.getName());
        for (ASMDataTable.ASMData data : asmDataSet) {
            try {
                Object object;
                Class<?> clazz = Class.forName(data.getClassName());
                IRegistryFactory.RegistryFactory registryFactory = (IRegistryFactory.RegistryFactory)RegistrationManager.getAnnoation(clazz.getAnnotations(), IRegistryFactory.RegistryFactory.class);
                if (!registryFactory.side().canExcetue() || !Loader.isModLoaded((String)registryFactory.modID()) || !((object = clazz.newInstance()) instanceof IRegistryFactory)) continue;
                IRegistryFactory factory = (IRegistryFactory)object;
                factoryList.put(((IRegistryFactory)object).getProcessSate(), factory);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setActiveMod(String modID) {
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (!modContainer.getModId().equals(modID)) continue;
            RegistrationManager.setActiveModContainer(modContainer);
            break;
        }
    }

    private static void setActiveModContainer(ModContainer container) {
        Loader.instance().setActiveModContainer(container);
    }
}

