/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeRemover {
    public static void removeShapedRecipes(List<ItemStack> removelist) {
        for (ItemStack stack : removelist) {
            RecipeRemover.removeShapedRecipe(stack);
        }
    }

    public static void removeAnyRecipe(ItemStack resultItem) {
        for (IRecipe tmpRecipe : CraftingManager.field_193380_a) {
            ItemStack recipeResult = tmpRecipe.func_77571_b();
            if (!ItemStack.func_77989_b((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            RecipeRemover.removeRecipe(tmpRecipe);
        }
    }

    public static void removeShapedRecipe(ItemStack resultItem) {
        for (IRecipe tmpRecipe : CraftingManager.field_193380_a) {
            ShapedRecipes recipe;
            ItemStack recipeResult;
            if (!(tmpRecipe instanceof ShapedRecipes) || !ItemStack.func_77989_b((ItemStack)resultItem, (ItemStack)(recipeResult = (recipe = (ShapedRecipes)tmpRecipe).func_77571_b()))) continue;
            RecipeRemover.removeRecipe((IRecipe)recipe);
        }
    }

    private static void removeRecipe(IRecipe recipe) {
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new BlankRecipe(recipe));
    }

    private static class BlankRecipe
    implements IRecipe {
        IRecipe oldRecipe;

        public BlankRecipe(IRecipe oldRecipe) {
            this.oldRecipe = oldRecipe;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return ItemStack.field_190927_a;
        }

        public boolean func_194133_a(int width, int height) {
            return false;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            return NonNullList.func_191196_a();
        }

        public IRecipe setRegistryName(ResourceLocation name) {
            return (IRecipe)this.oldRecipe.setRegistryName(name);
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return this.oldRecipe.getRegistryName();
        }

        public Class<IRecipe> getRegistryType() {
            return this.oldRecipe.getRegistryType();
        }
    }
}

